/*
 * Decompiled with CFR 0.152.
 */
package com.modderg.tameablebeasts.server.entity;

import com.modderg.tameablebeasts.client.entity.TBAnimControllers;
import com.modderg.tameablebeasts.registry.TBEntityRegistry;
import com.modderg.tameablebeasts.registry.TBItemRegistry;
import com.modderg.tameablebeasts.registry.TBPOITypesRegistry;
import com.modderg.tameablebeasts.registry.TBSoundRegistry;
import com.modderg.tameablebeasts.registry.TBTagRegistry;
import com.modderg.tameablebeasts.server.config.TBMobConfigs;
import com.modderg.tameablebeasts.server.entity.BeetleDrone;
import com.modderg.tameablebeasts.server.entity.abstracts.FlyingTBAnimal;
import com.modderg.tameablebeasts.server.entity.goals.IncludesSitingRidingMeleeAttackGoal;
import com.modderg.tameablebeasts.server.entity.goals.NoFlyRandomStrollGoal;
import com.modderg.tameablebeasts.server.entity.goals.TBFollowParentGoal;
import com.modderg.tameablebeasts.server.entity.goals.TBWaterAvoidRandomFlyingGoal;
import com.modderg.tameablebeasts.server.entity.goals.TakeCareOfEggsGoal;
import com.modderg.tameablebeasts.server.entity.goals.TameablePanicGoal;
import com.modderg.tameablebeasts.server.item.block.EggBlockItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.util.ClientUtils;

public class ShinyBeetleEntity
extends FlyingTBAnimal {
    int flyingSoundCount = 80;
    int particleCount = 5;

    public ShinyBeetleEntity(EntityType<? extends TamableAnimal> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.hasWarmthVariants();
        this.extraTameParticles = ParticleTypes.f_175827_;
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22280_, 0.2).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22284_, 15.0);
    }

    @Override
    public void updateAttributes() {
        double movSpeed = 0.3;
        if (this.m_6162_()) {
            movSpeed = 0.1;
        }
        this.m_21051_(Attributes.f_22279_).m_22100_(movSpeed);
        double maxHealth = 10.0;
        if (this.m_21824_()) {
            maxHealth += TBMobConfigs.GROUND_BEETLE.extraTameHP();
        }
        this.m_21051_(Attributes.f_22276_).m_22100_(maxHealth);
    }

    public static boolean checkFlyingBeetleSpawnRules(EntityType<ShinyBeetleEntity> p_218242_, LevelAccessor p_218243_, MobSpawnType p_218244_, BlockPos p_218245_, RandomSource p_218246_) {
        return TBMobConfigs.SHINY_BEETLE.canSpawnConfig();
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.addGoals(new Goal[]{new SitWhenOrderedToGoal((TamableAnimal)this), new OwnerHurtTargetGoal((TamableAnimal)this), new TakeCareOfEggsGoal((Animal)this, 15, TBPOITypesRegistry.FLYING_BEETLE_POI), new TameablePanicGoal((PathfinderMob)this, 1.25), new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_204132_(TBTagRegistry.Items.SHINY_BEETLE_FOOD), false), new NoFlyRandomStrollGoal(this, 1.0), new BreedGoal((Animal)this, 1.0), new AvoidEntityGoal((PathfinderMob)this, Player.class, 6.0f, 1.0, 1.2), new TBWaterAvoidRandomFlyingGoal(this, 1.0, 80), new TBFollowParentGoal(this, 1.0), new LookAtPlayerGoal((Mob)this, Player.class, 6.0f), new RandomLookAroundGoal((Mob)this)});
        this.addTargetGoals(new Goal[]{new IncludesSitingRidingMeleeAttackGoal(this, 1.0, true), new OwnerHurtTargetGoal((TamableAnimal)this), new OwnerHurtByTargetGoal((TamableAnimal)this)});
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            if (this.isServerFlying() && this.flyingSoundCount-- == 0) {
                this.m_216990_((SoundEvent)TBSoundRegistry.BEETLE_FLY.get());
                this.flyingSoundCount = 15;
            }
        } else if (this.isClientFlying() && this.particleCount-- == 0) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175827_, this.m_20208_(0.6), this.m_20187_(), this.m_20262_(0.6), 0.0, 0.0, 0.0);
            this.particleCount = 5;
        }
        if (!this.m_21827_() && this.m_5448_() != null && this.f_19797_ % 80 == 0) {
            ShinyBeetleEntity.spawnDroneWithTarget((LivingEntity)this, this.m_5448_());
        }
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.isTameFood(itemstack) && !this.m_21824_()) {
            this.tameTBAnimal(player, itemstack, 20);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public Item[] getBrushDrops() {
        return new Item[]{(Item)TBItemRegistry.BEETLE_ARMOR_PIECE.get(), (Item)TBItemRegistry.BEETLE_DUST.get()};
    }

    @Override
    public boolean isTameFood(ItemStack itemStack) {
        return itemStack.m_204117_(TBTagRegistry.Items.SHINY_BEETLE_FOOD);
    }

    public boolean m_6898_(ItemStack itemStack) {
        return itemStack.m_204117_(TBTagRegistry.Items.SHINY_BEETLE_TAME_FOOD);
    }

    @Override
    protected Boolean shouldFly() {
        LivingEntity owner = this.m_269323_();
        return super.shouldFly() != false && !this.m_6162_() && (this.getGoalsRequireFlying() && (!this.m_21824_() || this.isWandering()) || !this.m_217005_() && (this.m_5912_() || this.isOverFluidOrVoid()) || owner != null && (this.m_20270_((Entity)owner) > 10.0f && !this.isWandering() || this.isServerFlying() && !owner.m_20096_()));
    }

    @Override
    public EggBlockItem getEgg() {
        return (EggBlockItem)((Object)TBItemRegistry.FLYING_BEETLE_EGG_ITEM.get());
    }

    @Override
    public boolean m_7327_(@NotNull Entity entity) {
        if (!this.m_6162_() && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (this.f_19796_.m_188503_(100) < 5) {
                this.m_19998_((ItemLike)TBItemRegistry.BEETLE_DUST.get());
            }
            ShinyBeetleEntity.spawnDroneWithTarget((LivingEntity)this, living);
            ShinyBeetleEntity.spawnDroneWithTarget((LivingEntity)this, living);
        }
        return super.m_7327_(entity);
    }

    public boolean m_6469_(@NotNull DamageSource source, float p_27568_) {
        Entity entity;
        if (!this.m_6162_() && (entity = source.m_7639_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ShinyBeetleEntity.spawnDroneWithTarget((LivingEntity)this, living);
            ShinyBeetleEntity.spawnDroneWithTarget((LivingEntity)this, living);
            ShinyBeetleEntity.spawnDroneWithTarget((LivingEntity)this, living);
        }
        return super.m_6469_(source, p_27568_);
    }

    public static void spawnDroneWithTarget(LivingEntity entity, LivingEntity target) {
        BeetleDrone drone = (BeetleDrone)((EntityType)TBEntityRegistry.BEETLE_DRONE.get()).m_20615_(entity.m_9236_());
        if (drone == null) {
            return;
        }
        RandomSource random = entity.m_217043_();
        drone.m_6710_(target);
        drone.m_6034_(entity.m_20185_() + (double)((random.m_188501_() - random.m_188501_()) * 2.0f), entity.m_20186_() + (double)random.m_188501_(), entity.m_20189_() + (double)((random.m_188501_() - random.m_188501_()) * 2.0f));
        entity.m_9236_().m_7967_((Entity)drone);
        drone.m_5496_(SoundEvents.f_11696_, 1.0f, 1.0f);
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)TBSoundRegistry.BEETLE_AMBIENT.get();
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)TBSoundRegistry.BEETLE_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource p_21239_) {
        return (SoundEvent)TBSoundRegistry.BEETLE_HURT.get();
    }

    protected void m_7355_(@NotNull BlockPos p_20135_, @NotNull BlockState p_20136_) {
        this.m_5496_((SoundEvent)TBSoundRegistry.BEETLE_STEPS.get(), 0.15f, 1.0f);
    }

    @Override
    public SoundEvent getTameSound() {
        return (SoundEvent)TBSoundRegistry.BEETLE_INTERACT.get();
    }

    @Override
    public SoundEvent getInteractSound() {
        return (SoundEvent)TBSoundRegistry.BEETLE_INTERACT.get();
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar control) {
        control.add(new AnimationController[]{this.addAnimationTriggers(TBAnimControllers.flyWalkingController(this)).setSoundKeyframeHandler(state -> {
            Player player = ClientUtils.getClientPlayer();
            if (player != null) {
                player.m_216990_((SoundEvent)TBSoundRegistry.BEETLE_FLY.get());
            }
        })});
    }
}

