/*
 * Decompiled with CFR 0.152.
 */
package com.modderg.tameablebeasts.server.entity.abstracts;

import com.modderg.tameablebeasts.server.entity.abstracts.TBAnimal;
import com.modderg.tameablebeasts.server.entity.goals.TBFollowOwnerGoal;
import com.modderg.tameablebeasts.server.entity.navigation.TBFlyingPathNavigation;
import com.modderg.tameablebeasts.server.entity.navigation.TBGroundPathNavigation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class FlyingTBAnimal
extends TBAnimal {
    private static final EntityDataAccessor<Boolean> GOAL_WANT_FLYING = SynchedEntityData.m_135353_(FlyingTBAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_FLYING = SynchedEntityData.m_135353_(FlyingTBAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final MoveControl groundMoveControl;
    private final PathNavigation groundPathNavigation;
    private final FlyingMoveControl flyingMoveControl;
    private final PathNavigation TBFlyingPathNavigation;
    private boolean serverFlying = false;
    protected int flightCycleCount = this.f_19796_.m_188503_(2000);
    protected TBFollowOwnerGoal followOwnerGoal;

    protected FlyingTBAnimal(EntityType<? extends TamableAnimal> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.groundMoveControl = this.f_21342_ = new MoveControl((Mob)this);
        this.groundPathNavigation = this.f_21344_ = new TBGroundPathNavigation(this, this.m_9236_());
        this.flyingMoveControl = new FlyingMoveControl((Mob)this, 20, false);
        this.TBFlyingPathNavigation = new TBFlyingPathNavigation((Mob)this, this.m_9236_()).canFloat(true);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, -1.0f);
    }

    public boolean isServerFlying() {
        return this.serverFlying;
    }

    public boolean isClientFlying() {
        return (Boolean)this.f_19804_.m_135370_(IS_FLYING);
    }

    public void setGoalsRequireFlying(boolean i) {
        this.m_20088_().m_135381_(GOAL_WANT_FLYING, (Object)i);
    }

    public boolean getGoalsRequireFlying() {
        return (Boolean)this.m_20088_().m_135370_(GOAL_WANT_FLYING);
    }

    public int getFlightCycleCount() {
        return this.flightCycleCount;
    }

    @Override
    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("GOAL_WANT_FLYING", this.getGoalsRequireFlying());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(GOAL_WANT_FLYING, (Object)(!this.m_20096_() ? 1 : 0));
        this.f_19804_.m_135372_(IS_FLYING, (Object)false);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("GOAL_WANT_FLYING")) {
            this.setGoalsRequireFlying(compound.m_128471_("GOAL_WANT_FLYING"));
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.followOwnerGoal = new TBFollowOwnerGoal(this, 1.0, 10.0f, 6.0f, true);
        this.f_21345_.m_25352_(0, (Goal)this.followOwnerGoal);
    }

    protected Boolean shouldFly() {
        return !this.m_21827_();
    }

    protected void switchNavigation() {
        boolean shouldFly;
        this.serverFlying = shouldFly = this.shouldFly().booleanValue();
        this.f_19804_.m_135381_(IS_FLYING, (Object)shouldFly);
        this.f_21342_ = shouldFly ? this.flyingMoveControl : this.groundMoveControl;
        this.f_21344_ = shouldFly ? this.TBFlyingPathNavigation : this.groundPathNavigation;
        this.m_20242_(shouldFly);
        this.followOwnerGoal.refreshNavigatorPath();
    }

    public boolean isStill() {
        return !(this.m_20184_().m_165925_() > 0.001);
    }

    public void m_21839_(boolean p_21840_) {
        super.m_21839_(p_21840_);
    }

    public void m_8119_() {
        int uFlyModule;
        if (this.flightCycleCount-- < 0) {
            this.setGoalsRequireFlying(!this.getGoalsRequireFlying());
            this.flightCycleCount = this.f_19796_.m_188503_(2000);
        }
        int n = uFlyModule = this.m_21824_() ? 5 : 20;
        if (!this.m_9236_().m_5776_() && this.f_19797_ % uFlyModule == 0 && this.shouldFly().booleanValue() != this.isServerFlying()) {
            this.switchNavigation();
        }
        super.m_8119_();
    }

    public void m_7023_(@NotNull Vec3 p_218382_) {
        if (this.isServerFlying() && this.m_6109_()) {
            if (this.m_20069_()) {
                this.m_19920_(0.02f, p_218382_);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
            } else if (this.m_20077_()) {
                this.m_19920_(0.02f, p_218382_);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_(0.5));
            } else {
                this.m_19920_(this.m_6113_(), p_218382_);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.91f));
            }
        } else {
            super.m_7023_(p_218382_);
        }
    }

    protected boolean isOverFluidOrVoid() {
        BlockPos.MutableBlockPos pos = this.m_20183_().m_122032_();
        Level level = this.m_9236_();
        for (int i = 0; i < 15 && pos.m_123342_() > level.m_141937_(); ++i) {
            if (!level.m_46859_((BlockPos)pos) || !level.m_6425_((BlockPos)pos).m_76178_()) {
                return !level.m_6425_((BlockPos)pos).m_76178_();
            }
            pos.m_122173_(Direction.DOWN);
        }
        return pos.m_123342_() <= level.m_141937_();
    }

    public boolean m_20068_() {
        return this.isServerFlying();
    }

    public boolean m_142535_(float p_147187_, float p_147188_, @NotNull DamageSource p_147189_) {
        return false;
    }
}

