/*
 * Decompiled with CFR 0.152.
 */
package com.modderg.tameablebeasts.server.entity.abstracts;

import com.modderg.tameablebeasts.client.gui.TBItemStackHandler;
import com.modderg.tameablebeasts.client.gui.TBMenu;
import com.modderg.tameablebeasts.registry.TBPacketRegistry;
import com.modderg.tameablebeasts.server.entity.abstracts.FlyingTBAnimal;
import com.modderg.tameablebeasts.server.entity.navigation.TBGroundPathNavigation;
import com.modderg.tameablebeasts.server.item.block.EggBlockItem;
import com.modderg.tameablebeasts.server.packet.StoCEntityInvSyncPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class TBAnimal
extends TamableAnimal
implements GeoEntity,
HasCustomInventoryScreen {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> TEXTURE_ID = SynchedEntityData.m_135353_(TBAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> WANDERING = SynchedEntityData.m_135353_(TBAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Integer> HAPPINESS = SynchedEntityData.m_135353_(TBAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Boolean> GOALS_WANT_RUNNING = SynchedEntityData.m_135353_(TBAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected ItemStackHandler inventory = new TBItemStackHandler(this, 0);
    protected final LazyOptional<ItemStackHandler> invCapability = LazyOptional.of(() -> this.inventory);
    public int stillDuringInteractAnim = -1;
    protected List<String> attackAnims = new ArrayList<String>();
    protected boolean warmVariants = false;
    protected ParticleOptions extraTameParticles = ParticleTypes.f_123796_;
    protected int textureIdSize = 0;
    public float cachedHeadYaw = 0.0f;
    public float cachedHeadPitch = 0.0f;

    protected void hasWarmthVariants() {
        this.warmVariants = true;
    }

    public TBAnimal(EntityType<? extends TamableAnimal> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.f_21342_ = this.createMoveControl();
    }

    public void updateAttributes() {
    }

    protected void addGoals(Goal ... goals) {
        int i = 0;
        for (Goal goal : goals) {
            this.f_21345_.m_25352_(++i, goal);
        }
    }

    protected void addTargetGoals(Goal ... goals) {
        int i = 0;
        for (Goal goal : goals) {
            this.f_21346_.m_25352_(++i, goal);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TEXTURE_ID, (Object)0);
        this.f_19804_.m_135372_(WANDERING, (Object)false);
        this.f_19804_.m_135372_(GOALS_WANT_RUNNING, (Object)false);
        this.f_19804_.m_135372_(HAPPINESS, (Object)0);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("TEXTURE_ID", this.getTextureID());
        compound.m_128379_("WANDERING", this.isWandering());
        compound.m_128379_("GOALS_WANT_RUNNING", this.isRunning());
        compound.m_128405_("HAPPINESS", this.getHappiness());
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("TEXTURE_ID")) {
            this.setTextureId(compound.m_128451_("TEXTURE_ID"));
        }
        if (compound.m_128441_("WANDERING")) {
            this.setWandering(compound.m_128471_("WANDERING"));
        }
        if (compound.m_128441_("GOALS_WANT_RUNNING")) {
            this.setWandering(compound.m_128471_("GOALS_WANT_RUNNING"));
        }
        if (compound.m_128441_("HAPPINESS")) {
            this.setHappiness(compound.m_128451_("HAPPINESS"));
        }
        if (compound.m_128441_("Inventory")) {
            this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        }
        this.updateAttributes();
    }

    protected void m_21834_(boolean p_21835_) {
        int pAmount = 18;
        ParticleOptions[] particles = new ParticleOptions[]{ParticleTypes.f_123750_, this.extraTameParticles};
        if (!p_21835_) {
            particles = new ParticleOptions[]{ParticleTypes.f_123762_};
            pAmount = 7;
        }
        for (int i = 0; i < pAmount; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_(particles[this.m_217043_().m_188503_(particles.length)], this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    public void setTextureId(int i) {
        if (i > 2 && this.warmVariants) {
            i = this.f_19796_.m_188503_(3);
        }
        this.m_20088_().m_135381_(TEXTURE_ID, (Object)i);
    }

    public int getTextureID() {
        return (Integer)this.m_20088_().m_135370_(TEXTURE_ID);
    }

    public void setWandering(boolean i) {
        this.m_20088_().m_135381_(WANDERING, (Object)i);
    }

    public boolean isWandering() {
        return (Boolean)this.m_20088_().m_135370_(WANDERING);
    }

    public boolean isRunning() {
        return (Boolean)this.m_20088_().m_135370_(GOALS_WANT_RUNNING);
    }

    public void setRunning(boolean i) {
        this.m_20088_().m_135381_(GOALS_WANT_RUNNING, (Object)i);
        this.updateAttributes();
    }

    public void setHappiness(int i) {
        this.m_20088_().m_135381_(HAPPINESS, (Object)i);
    }

    public int getHappiness() {
        return (Integer)this.m_20088_().m_135370_(HAPPINESS);
    }

    public Item[] getBrushDrops() {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_6779_(@NotNull LivingEntity target) {
        if (target instanceof TBAnimal) {
            TBAnimal tg = (TBAnimal)target;
            LivingEntity livingEntity = this.m_269323_();
            if (livingEntity instanceof Player) {
                Player p = (Player)livingEntity;
                if (tg.m_21830_((LivingEntity)p)) return false;
            }
        }
        if (!super.m_6779_(target)) return false;
        return true;
    }

    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor levelAccessor, @NotNull DifficultyInstance p_146747_, @NotNull MobSpawnType p_146748_, @Nullable SpawnGroupData p_146749_, @Nullable CompoundTag p_146750_) {
        if (this.warmVariants) {
            Holder biome = this.m_9236_().m_204166_(this.m_20183_());
            float temperature = ((Biome)biome.m_203334_()).m_47554_();
            int variant = 1;
            if (temperature < 0.3f) {
                variant = 0;
            } else if (temperature > 0.9f) {
                variant = 2;
            }
            this.setTextureId(variant);
        } else if (this.textureIdSize > 0) {
            this.setTextureId(this.f_19796_.m_188503_(this.textureIdSize));
        }
        return super.m_6518_(levelAccessor, p_146747_, p_146748_, p_146749_, p_146750_);
    }

    public void m_8107_() {
        if (this.m_21824_()) {
            if (!this.m_9236_().f_46443_ && this.m_6084_() && this.f_19797_ % (int)Math.exp((double)(-(this.getHappiness() - 165)) * 0.045) == 0) {
                this.m_5634_(1.0f);
            }
            if (this.m_6084_() && this.f_19797_ % 25 == 0) {
                this.setHappiness(Math.max(this.getHappiness() - 1, 0));
            }
        }
        super.m_8107_();
        if (this.stillDuringInteractAnim-- > 0) {
            this.m_21573_().m_26573_();
            this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.invCapability.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.invCapability.invalidate();
    }

    public void m_213583_(@NotNull Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)player;
            Component baseName = this.m_8077_() ? this.m_7770_() : this.m_7755_();
            MutableComponent fullTitle = baseName.m_6881_();
            Object trimmed = fullTitle.getString();
            int charLimit = 20;
            if (((String)trimmed).length() > charLimit) {
                trimmed = ((String)trimmed).substring(0, charLimit - 3) + "...";
            }
            MutableComponent safeTitle = Component.m_237113_((String)trimmed);
            safeTitle = safeTitle.m_6881_().m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"key.categories.inventory"));
            NetworkHooks.openScreen((ServerPlayer)sPlayer, (MenuProvider)new SimpleMenuProvider((id, playerInventory, playerEntity) -> this.createMenu(id, playerInventory), (Component)safeTitle), buffer -> buffer.writeInt(this.m_19879_()));
        }
    }

    protected TBMenu createMenu(int containerId, Inventory playerInventory) {
        return new TBMenu(containerId, playerInventory, (Entity)this);
    }

    public void m_6667_(@NotNull DamageSource p_21809_) {
        if (this.m_21824_()) {
            IntStream.range(0, this.inventory.getSlots()).forEach(i -> {
                int amount = this.inventory.getStackInSlot(i).m_41613_();
                ItemStack stack = this.inventory.extractItem(i, amount, false);
                if (!stack.m_41619_()) {
                    this.m_19983_(stack);
                }
            });
        }
        super.m_6667_(p_21809_);
    }

    public void m_6457_(@NotNull ServerPlayer player) {
        super.m_6457_(player);
        if (!this.m_21824_()) {
            return;
        }
        player.f_8924_.execute(() -> {
            ArrayList<ItemStack> copy = new ArrayList<ItemStack>();
            for (int i = 0; i < this.getInventory().getSlots(); ++i) {
                ItemStack stack = this.getInventory().getStackInSlot(i);
                if (stack.m_41619_()) continue;
                copy.add(stack.m_41777_());
            }
            TBPacketRegistry.sendToClient(new StoCEntityInvSyncPacket(this.m_19879_(), copy), player);
        });
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        boolean client = this.m_9236_().f_46443_;
        this.m_5496_(this.getInteractSound(), 0.45f, 1.0f);
        if (this.m_21830_((LivingEntity)player)) {
            ItemStack stack = player.m_21120_(hand);
            if (this.getBrushDrops() != null && stack.m_150930_(Items.f_271356_)) {
                player.m_6672_(hand);
                return InteractionResult.SUCCESS;
            }
            if (this.m_6898_(player.m_21120_(hand))) {
                this.m_216990_(SoundEvents.f_11912_);
                this.setHappiness(Math.min(this.getHappiness() + 35, 100));
                this.handleInteract();
                if (!this.m_5957_()) {
                    this.m_142075_(player, hand, stack);
                    return InteractionResult.SUCCESS;
                }
                return super.m_6071_(player, hand);
            }
            if (this.isTameFood(player.m_21120_(hand))) {
                this.m_216990_(SoundEvents.f_11912_);
            }
            if (!player.m_6144_()) {
                this.m_213583_(player);
            } else {
                if (!this.m_21825_() && !this.isWandering()) {
                    this.setWandering(true);
                    if (client) {
                        this.messageState("wandering", player);
                    }
                    return InteractionResult.m_19078_((boolean)client);
                }
                this.setWandering(false);
                if (client) {
                    this.messageState(this.m_21825_() ? "following" : "sitting", player);
                }
                this.m_21837_(!this.m_21825_());
                this.m_21839_(!this.m_21827_());
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_20256_(Vec3.f_82478_);
                if (this.m_21825_()) {
                    this.m_7355_(this.m_20097_(), this.m_9236_().m_8055_(this.m_20097_()));
                }
                return InteractionResult.m_19078_((boolean)client);
            }
        }
        if (!this.m_9236_().m_5776_() && !this.m_21825_()) {
            this.handleInteract();
        }
        return super.m_6071_(player, hand);
    }

    public void handleInteract() {
        FlyingTBAnimal flyAnimal;
        TBAnimal tBAnimal = this;
        if (tBAnimal instanceof FlyingTBAnimal && !(flyAnimal = (FlyingTBAnimal)tBAnimal).isServerFlying()) {
            this.triggerAnim("movement", "interact");
        }
        this.stillDuringInteractAnim = 20;
    }

    public boolean m_21827_() {
        return !this.m_20160_() && super.m_21827_();
    }

    public boolean m_21825_() {
        return !this.m_20160_() && super.m_21825_();
    }

    public boolean isTameFood(ItemStack itemStack) {
        return false;
    }

    public void tameTBAnimal(Player player, ItemStack itemStack, int chance) {
        if (!player.m_150110_().f_35937_ && itemStack != null) {
            itemStack.m_41774_(1);
        }
        if (this.f_19796_.m_188503_(100) < chance && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
            this.m_21828_(player);
            this.m_9236_().m_7605_((Entity)this, (byte)7);
            this.m_5496_(this.getTameSound(), 0.15f, 1.0f);
        } else {
            this.m_9236_().m_7605_((Entity)this, (byte)6);
        }
    }

    public void m_7105_(boolean flag) {
        super.m_7105_(flag);
        this.updateAttributes();
    }

    public EggBlockItem getEgg() {
        return null;
    }

    public boolean breedDropsEgg() {
        return this.getEgg() != null && this.m_21824_();
    }

    public int genChildTextId(AgeableMob parent) {
        if (parent instanceof TBAnimal) {
            TBAnimal animal = (TBAnimal)parent;
            return animal.getTextureID();
        }
        return 0;
    }

    public void m_27563_(@NotNull ServerLevel level, @NotNull Animal mob) {
        if (!this.breedDropsEgg()) {
            super.m_27563_(level, mob);
            return;
        }
        ItemStack item = new ItemStack((ItemLike)this.getEgg());
        this.m_19983_(EggBlockItem.setTextureId(item, this.getTextureID()));
        super.m_277117_(level, mob, null);
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel p_146743_, @NotNull AgeableMob parent) {
        if (this.m_21824_()) {
            return null;
        }
        TBAnimal animal = (TBAnimal)this.m_6095_().m_20615_(this.m_9236_());
        animal.setTextureId(this.genChildTextId(parent));
        return animal;
    }

    public LivingEntity m_6688_() {
        LivingEntity passenger;
        Object e;
        if (!this.m_20197_().isEmpty() && (e = this.m_20197_().get(0)) instanceof LivingEntity && this.m_21830_(passenger = (LivingEntity)e)) {
            return passenger;
        }
        return null;
    }

    @NotNull
    public MoveControl createMoveControl() {
        return new MoveControl((Mob)this);
    }

    @NotNull
    public PathNavigation m_6037_(@NotNull Level p_21480_) {
        return new TBGroundPathNavigation(this, this.m_9236_());
    }

    public void setMoveControl(MoveControl control) {
        this.f_21342_ = control;
    }

    public void setPathNavigation(PathNavigation navigation) {
        this.f_21344_ = navigation;
    }

    public SoundEvent getTameSound() {
        return null;
    }

    public SoundEvent getInteractSound() {
        return null;
    }

    public void messageState(String txt, Player player) {
        if (player instanceof LocalPlayer) {
            Minecraft.m_91087_().f_91065_.m_93063_((Component)Component.m_237113_((String)txt), false);
        }
    }

    public void spawnItemParticles(ItemStack p_21061_, int p_21062_, Entity animal) {
        for (int i = 0; i < p_21062_; ++i) {
            Vec3 vec3 = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3 = vec3.m_82496_(-animal.m_146909_() * ((float)Math.PI / 180));
            vec3 = vec3.m_82524_(-animal.m_146908_() * ((float)Math.PI / 180));
            double d0 = (double)(-this.f_19796_.m_188501_()) * 0.6 - 0.3;
            Vec3 vec31 = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.3, d0, 0.6);
            vec31 = vec31.m_82496_(-animal.m_146909_() * ((float)Math.PI / 180));
            vec31 = vec31.m_82524_(-animal.m_146908_() * ((float)Math.PI / 180));
            vec31 = vec31.m_82520_(animal.m_20185_(), animal.m_20188_(), animal.m_20189_());
            if (animal.m_9236_() instanceof ServerLevel) {
                ((ServerLevel)animal.m_9236_()).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, p_21061_), vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, 1, vec3.f_82479_, vec3.f_82480_ + 0.05, vec3.f_82481_, 0.0);
                continue;
            }
            animal.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, p_21061_), vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, vec3.f_82479_, vec3.f_82480_ + 0.05, vec3.f_82481_);
        }
    }

    @NotNull
    public Component m_7755_() {
        if (!this.warmVariants) {
            return super.m_7755_();
        }
        if (this.m_8077_()) {
            return Objects.requireNonNull(this.m_7770_());
        }
        ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey((Object)this.m_6095_());
        String base = "entity." + key.m_135827_() + "." + key.m_135815_();
        return switch (this.getTextureID()) {
            case 0 -> Component.m_237115_((String)(base + ".cold"));
            case 1 -> Component.m_237115_((String)(base + ".temperate"));
            default -> Component.m_237115_((String)(base + ".warm"));
        };
    }

    public boolean m_7327_(@NotNull Entity p_21372_) {
        if (!this.attackAnims.isEmpty()) {
            this.playAttackAnim();
        }
        return super.m_7327_(p_21372_);
    }

    public void playAttackAnim() {
        this.triggerAnim("movement", "attack");
    }

    public AnimationController<?> addAnimationTriggers(AnimationController<?> controller) {
        for (String attack : this.attackAnims) {
            controller.triggerableAnim(attack, RawAnimation.begin().then(attack, Animation.LoopType.PLAY_ONCE));
        }
        controller.triggerableAnim("interact", RawAnimation.begin().then("interact", Animation.LoopType.PLAY_ONCE));
        return controller;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

