/*
 * Decompiled with CFR 0.152.
 */
package com.modderg.tameablebeasts.server.entity.goals;

import com.modderg.tameablebeasts.server.entity.abstracts.FlyingTBAnimal;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class TBWaterAvoidRandomFlyingGoal
extends Goal {
    protected final FlyingTBAnimal mob;
    protected final double speedModifier;
    protected final int maxInterval;
    protected Vec3 wantedPos;
    protected int interval;

    public TBWaterAvoidRandomFlyingGoal(FlyingTBAnimal mob, double speedMod, int interval) {
        this.mob = mob;
        this.speedModifier = speedMod;
        this.maxInterval = interval;
        this.interval = mob.m_217043_().m_188503_(interval);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.mob.m_20160_() || !this.mob.isServerFlying()) {
            return false;
        }
        if (this.mob.m_21216_() >= 100) {
            return false;
        }
        if (!(this.interval <= 0 || this.mob.isServerFlying() && this.mob.getFlightCycleCount() < 100)) {
            --this.interval;
            return false;
        }
        this.wantedPos = this.mob.getFlightCycleCount() < 100 && this.mob.isServerFlying() ? this.findLandingSpot() : this.getPosition();
        return this.wantedPos != null;
    }

    public boolean m_8045_() {
        return !this.mob.m_21573_().m_26571_() && !this.mob.m_20160_();
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26519_(this.wantedPos.f_82479_, this.wantedPos.f_82480_, this.wantedPos.f_82481_, this.speedModifier);
    }

    public void m_8041_() {
        this.interval = this.mob.m_217043_().m_188503_(this.maxInterval);
        this.mob.m_21573_().m_26573_();
        super.m_8041_();
    }

    @Nullable
    protected Vec3 getPosition() {
        Vec3 look = this.mob.m_20252_(0.0f);
        int range = 15;
        Vec3 hover = HoverRandomPos.m_148465_((PathfinderMob)this.mob, (int)range, (int)7, (double)look.f_82479_, (double)look.f_82481_, (float)1.5707964f, (int)3, (int)1);
        if (hover != null) {
            return hover;
        }
        return AirAndWaterRandomPos.m_148357_((PathfinderMob)this.mob, (int)range, (int)4, (int)-2, (double)look.f_82479_, (double)look.f_82481_, (double)1.5707963705062866);
    }

    @Nullable
    protected Vec3 findLandingSpot() {
        if (this.mob.m_20096_()) {
            return null;
        }
        BlockPos pos = this.mob.m_20183_();
        Level level = this.mob.m_9236_();
        while (pos.m_123342_() > level.m_141937_() && level.m_46859_(pos)) {
            pos = pos.m_7495_();
        }
        BlockPos landing = pos.m_7494_();
        if (level.m_46859_(landing)) {
            return Vec3.m_82512_((Vec3i)landing);
        }
        return null;
    }
}

