/*
 * Decompiled with CFR 0.152.
 */
package com.modderg.tameablebeasts.server.events;

import com.modderg.tameablebeasts.registry.TBAdvancementRegistry;
import com.modderg.tameablebeasts.registry.TBBlockRegistry;
import com.modderg.tameablebeasts.registry.TBEnchantmentRegistry;
import com.modderg.tameablebeasts.registry.TBEntityRegistry;
import com.modderg.tameablebeasts.registry.TBItemRegistry;
import com.modderg.tameablebeasts.registry.TBPacketRegistry;
import com.modderg.tameablebeasts.server.config.ModCommonConfigs;
import com.modderg.tameablebeasts.server.entity.BeetleDrone;
import com.modderg.tameablebeasts.server.entity.FurGolemEntity;
import com.modderg.tameablebeasts.server.entity.ShinyBeetleEntity;
import com.modderg.tameablebeasts.server.entity.abstracts.TBAnimal;
import com.modderg.tameablebeasts.server.packet.StoCEntityInvSyncPacket;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tameablebeasts")
public class ServerForgeEvents {
    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        TBAnimal tbAnimal;
        Entity entity = event.getEntity();
        if (entity instanceof TBAnimal && (tbAnimal = (TBAnimal)entity).m_21824_()) {
            event.getLevel().m_7654_().execute(() -> {
                ArrayList<ItemStack> copy = new ArrayList<ItemStack>();
                for (int i = 0; i < tbAnimal.getInventory().getSlots(); ++i) {
                    ItemStack stack = tbAnimal.getInventory().getStackInSlot(i);
                    if (stack.m_41619_()) continue;
                    copy.add(stack.m_41777_());
                }
                TBPacketRegistry.sendToAll(new StoCEntityInvSyncPacket(tbAnimal.m_19879_(), copy));
            });
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity entity;
        LivingEntity player = event.getEntity();
        if (player == null || !((entity = event.getSource().m_7639_()) instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        int enchantLevel = 0;
        for (ItemStack weapon : player.m_6167_()) {
            Item item = weapon.m_41720_();
            if (!(item instanceof ShieldItem)) continue;
            ShieldItem shield = (ShieldItem)item;
            if (!player.m_21211_().m_150930_((Item)shield)) continue;
            enchantLevel += EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)TBEnchantmentRegistry.SWARM_ENCHANTMENT.get()), (ItemStack)weapon);
        }
        if (enchantLevel == 0) {
            for (ItemStack armor : player.m_6168_()) {
                enchantLevel += EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)TBEnchantmentRegistry.SWARM_ENCHANTMENT.get()), (ItemStack)armor);
            }
        }
        for (int i = 0; i < enchantLevel; ++i) {
            if (player.m_217043_().m_188503_(3) == 1) continue;
            ShinyBeetleEntity.spawnDroneWithTarget(player, attacker);
            ShinyBeetleEntity.spawnDroneWithTarget(player, attacker);
        }
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof AbstractIllager) {
            AbstractIllager illager = (AbstractIllager)livingEntity;
            if (event.getEntity().m_217043_().m_188503_(100) <= 5) {
                illager.m_19998_((ItemLike)TBItemRegistry.PURPLE_ALLAY.get());
            }
        }
        if (event.getEntity().m_6336_().equals(MobType.f_21642_) && !(event.getEntity() instanceof BeetleDrone) && event.getEntity().m_217043_().m_188503_(100) <= (Integer)ModCommonConfigs.ARTHROPOD_TRIM_DROP_CHANCE.get()) {
            event.getEntity().m_19998_((ItemLike)TBItemRegistry.ARTHROPOD_SMITHING_TEMPLATE.get());
        }
    }

    @SubscribeEvent
    public static void onPlace(BlockEvent.EntityPlaceEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        Level level = event.getEntity().m_9236_();
        BlockState blockState = event.getPlacedBlock();
        BlockPos pos = event.getPos();
        if (blockState.m_60713_((Block)TBBlockRegistry.FUR_BLOCK.get())) {
            if (level.m_8055_(pos.m_7495_()).m_60713_((Block)TBBlockRegistry.FUR_BLOCK.get()) && level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_50143_)) {
                level.m_46961_(pos, false);
                level.m_46961_(pos.m_7494_(), false);
                level.m_46961_(pos.m_7495_(), false);
                ServerForgeEvents.summonGolem(level, event.getPos().m_7495_(), event);
            }
            if (level.m_8055_(pos.m_7494_()).m_60713_((Block)TBBlockRegistry.FUR_BLOCK.get()) && level.m_8055_(pos.m_7494_().m_7494_()).m_60713_(Blocks.f_50143_)) {
                level.m_46961_(pos, false);
                level.m_46961_(pos.m_6630_(2), false);
                level.m_46961_(pos.m_7494_(), false);
                ServerForgeEvents.summonGolem(level, event.getPos(), event);
            }
        }
        if (blockState.m_60713_(Blocks.f_50143_) && level.m_8055_(pos.m_7495_()).m_60713_((Block)TBBlockRegistry.FUR_BLOCK.get()) && level.m_8055_(pos.m_7495_().m_7495_()).m_60713_((Block)TBBlockRegistry.FUR_BLOCK.get())) {
            level.m_46961_(pos, false);
            level.m_46961_(pos.m_7495_(), false);
            level.m_46961_(pos.m_6625_(2), false);
            ServerForgeEvents.summonGolem(level, event.getPos().m_6625_(2), event);
        }
    }

    public static void summonGolem(Level level, BlockPos pos, BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            TBAdvancementRegistry.grantAdvancement(player, TBAdvancementRegistry.FUR_GOLEM);
        }
        FurGolemEntity golem = new FurGolemEntity((EntityType<? extends Animal>)((EntityType)TBEntityRegistry.FUR_GOLEM.get()), level);
        golem.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        level.m_7967_((Entity)golem);
    }
}

