/*
 * Decompiled with CFR 0.152.
 */
package com.modderg.tameablebeasts.server.item;

import com.modderg.tameablebeasts.client.item.BugElytraChestplateRenderer;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class BugElytraChestplateItem
extends ArmorItem
implements GeoItem {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    boolean isFlying = false;

    public BugElytraChestplateItem(ArmorMaterial p_40386_, ArmorItem.Type p_266831_, Item.Properties p_40388_) {
        super(p_40386_, p_266831_, p_40388_);
    }

    public static boolean isFlyEnabled(ItemStack p_41141_) {
        return p_41141_.m_41773_() < p_41141_.m_41776_() - 1;
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
        this.isFlying = player.m_21255_();
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return BugElytraChestplateItem.isFlyEnabled(stack);
    }

    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private BugElytraChestplateRenderer renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new BugElytraChestplateRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        if (!entity.m_9236_().f_46443_) {
            int nextFlightTick = flightTicks + 1;
            if (nextFlightTick % 10 == 0) {
                if (nextFlightTick % 20 == 0) {
                    stack.m_41622_(1, entity, e -> e.m_21166_(EquipmentSlot.CHEST));
                }
                entity.m_146850_(GameEvent.f_223705_);
            }
        } else {
            entity.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175827_, entity.m_20208_(0.6), entity.m_20187_(), entity.m_20262_(0.6), 0.0, 0.0, 0.0);
        }
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{this.elytraController(this)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object itemStack) {
        return super.getTick(itemStack);
    }

    public <T extends BugElytraChestplateItem> AnimationController<BugElytraChestplateItem> elytraController(BugElytraChestplateItem item) {
        return new AnimationController((GeoAnimatable)item, "movement", 15, event -> {
            if (item.isFlying) {
                event.getController().setAnimation(RawAnimation.begin().then("flying", Animation.LoopType.LOOP));
            } else {
                event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            }
            return PlayState.CONTINUE;
        });
    }
}

