/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.block.custom;

import net.farkas.wildaside.block.ModBlocks;
import net.farkas.wildaside.block.custom.FallenHickoryLeavesBlock;
import net.farkas.wildaside.item.ModItems;
import net.farkas.wildaside.particle.ModParticles;
import net.farkas.wildaside.util.GlowingHickoryLightUtil;
import net.farkas.wildaside.util.HickoryColour;
import net.farkas.wildaside.util.ParticleUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class GlowingHickoryLeavesBlock
extends LeavesBlock {
    private static final int MIN_LIGHT = 0;
    private static final int MAX_LIGHT = 7;
    public static final IntegerProperty LIGHT = IntegerProperty.create((String)"light", (int)0, (int)7);
    public static final BooleanProperty FIXED_LIGHTING = BooleanProperty.create((String)"fixed_lighting");
    private final HickoryColour colour;

    public GlowingHickoryLeavesBlock(BlockBehaviour.Properties pProperties, HickoryColour colour) {
        super(pProperties.lightLevel(s -> (Integer)s.getValue((Property)LIGHT)));
        this.colour = colour;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DISTANCE, (Comparable)Integer.valueOf(7))).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)LIGHT, (Comparable)Integer.valueOf(0))).setValue((Property)FIXED_LIGHTING, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{DISTANCE, PERSISTENT, WATERLOGGED, LIGHT, FIXED_LIGHTING});
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        if (!pLevel.isClientSide) {
            pLevel.scheduleTick(pPos, (Block)this, 0);
        }
        super.onPlace(pState, pLevel, pPos, pOldState, pMovedByPiston);
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        if (pLevel.isClientSide || pHand == InteractionHand.OFF_HAND || ((Boolean)pState.getValue((Property)FIXED_LIGHTING)).booleanValue()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ItemStack playerItem = pPlayer.getItemInHand(pHand);
        if (playerItem.getItem().equals(ModItems.VIBRION.get())) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)FIXED_LIGHTING, (Comparable)Boolean.valueOf(true)), 3);
            pLevel.playSound(null, pPos, SoundEvents.HONEYCOMB_WAX_ON, SoundSource.BLOCKS, 1.0f, 1.0f);
            pPlayer.swing(pHand);
            if (!pPlayer.isInvulnerable()) {
                playerItem.shrink(1);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.tick(pState, pLevel, pPos, pRandom);
        if (pLevel.isClientSide() || ((Boolean)pState.getValue((Property)FIXED_LIGHTING)).booleanValue()) {
            return;
        }
        int time = (int)pLevel.dayTime();
        int currentLight = (Integer)pState.getValue((Property)LIGHT);
        int newLight = GlowingHickoryLightUtil.getLight(time, 0, 7);
        if (newLight != currentLight) {
            pLevel.setBlockAndUpdate(pPos, (BlockState)pState.setValue((Property)LIGHT, (Comparable)Integer.valueOf(newLight)));
        }
        pLevel.scheduleTick(pPos, (Block)this, 100);
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        super.animateTick(pState, pLevel, pPos, pRandom);
        if (pLevel.getBlockState(pPos.below()).isFaceSturdy((BlockGetter)pLevel, pPos.below(), Direction.UP)) {
            return;
        }
        SimpleParticleType particle = ModParticles.HICKORY_PARTICLES.get((Object)this.colour).get();
        if ((double)pRandom.nextFloat() < 0.025) {
            ParticleUtils.spawnHickoryParticles(pLevel, pPos, pRandom, particle);
        }
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if ((double)pRandom.nextFloat() < 0.025) {
            this.spawnNewFallenLeaves((Level)pLevel, pPos, pRandom);
        }
        super.randomTick(pState, pLevel, pPos, pRandom);
    }

    private void spawnNewFallenLeaves(Level level, BlockPos pPos, RandomSource random) {
        if (level.isClientSide) {
            return;
        }
        int x = pPos.getX() + random.nextIntBetweenInclusive(-2, 2);
        int z = pPos.getZ() + random.nextIntBetweenInclusive(-2, 2);
        int groundY = -100;
        for (int y = pPos.getY(); y >= -64; --y) {
            BlockPos pos = new BlockPos(x, y, z);
            if (!level.getBlockState(pos).isFaceSturdy((BlockGetter)level, pos, Direction.UP)) continue;
            BlockState aboveState = level.getBlockState(pos.above());
            if (!aboveState.isAir() && !(aboveState.getBlock() instanceof FallenHickoryLeavesBlock)) break;
            groundY = y;
            break;
        }
        if (groundY > -64) {
            Direction direction;
            BlockPos target = new BlockPos(x, groundY + 1, z);
            BlockState state = level.getBlockState(target);
            int count = 1;
            if (state.getBlock() instanceof FallenHickoryLeavesBlock) {
                if (state.getValue(FallenHickoryLeavesBlock.COLOUR) != this.colour) {
                    return;
                }
                count = Math.min((Integer)level.getBlockState(target).getValue((Property)FallenHickoryLeavesBlock.COUNT) + 1, 3);
                direction = (Direction)level.getBlockState(target).getValue((Property)FallenHickoryLeavesBlock.FACING);
            } else {
                direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
            }
            BlockState leafSt = (BlockState)((BlockState)((BlockState)((Block)ModBlocks.FALLEN_HICKORY_LEAVES.get()).defaultBlockState().setValue((Property)FallenHickoryLeavesBlock.COUNT, (Comparable)Integer.valueOf(count))).setValue(FallenHickoryLeavesBlock.COLOUR, (Comparable)((Object)this.colour))).setValue((Property)FallenHickoryLeavesBlock.FACING, (Comparable)direction);
            level.setBlock(target, leafSt, 3);
        }
    }

    public boolean isRandomlyTicking(BlockState pState) {
        return true;
    }
}

