/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.block.custom;

import net.farkas.wildaside.block.custom.GlowingHickoryLeavesBlock;
import net.farkas.wildaside.item.ModItems;
import net.farkas.wildaside.util.GlowingHickoryLightUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GlowingHickorySaplingBlock
extends SaplingBlock {
    public static final IntegerProperty STAGE = BlockStateProperties.STAGE;
    protected static final float AABB_OFFSET = 6.0f;
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    private static final int MIN_LIGHT = 0;
    private static final int MAX_LIGHT = 7;
    public static final IntegerProperty LIGHT = IntegerProperty.create((String)"light", (int)0, (int)7);
    public static final BooleanProperty FIXED_LIGHTING = BooleanProperty.create((String)"fixed_lighting");

    public GlowingHickorySaplingBlock(TreeGrower pTreeGrower, BlockBehaviour.Properties pProperties) {
        super(pTreeGrower, pProperties.lightLevel(s -> (Integer)s.getValue((Property)LIGHT)));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)STAGE, (Comparable)Integer.valueOf(0))).setValue((Property)LIGHT, (Comparable)Integer.valueOf(0))).setValue((Property)FIXED_LIGHTING, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{STAGE, LIGHT, FIXED_LIGHTING});
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        if (!pLevel.isClientSide) {
            pLevel.scheduleTick(pPos, (Block)this, 0);
        }
        super.onPlace(pState, pLevel, pPos, pOldState, pMovedByPiston);
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        if (pLevel.isClientSide || pHand == InteractionHand.OFF_HAND) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ItemStack playerItem = pPlayer.getItemInHand(pHand);
        if (playerItem.getItem().equals(ModItems.VIBRION.get())) {
            if (((Boolean)pState.getValue((Property)GlowingHickoryLeavesBlock.FIXED_LIGHTING)).booleanValue()) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)FIXED_LIGHTING, (Comparable)Boolean.valueOf(true)), 3);
            pLevel.playSound(null, pPos, SoundEvents.HONEYCOMB_WAX_ON, SoundSource.BLOCKS, 1.0f, 1.0f);
            pPlayer.swing(pHand);
            if (!pPlayer.isInvulnerable()) {
                playerItem.shrink(1);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.tick(pState, pLevel, pPos, pRandom);
        if (pLevel.isClientSide() || ((Boolean)pState.getValue((Property)FIXED_LIGHTING)).booleanValue()) {
            return;
        }
        int time = (int)pLevel.dayTime();
        int currentLight = (Integer)pLevel.getBlockState(pPos).getValue((Property)LIGHT);
        int newLight = GlowingHickoryLightUtil.getLight(time, 0, 7);
        if (newLight != currentLight) {
            pLevel.setBlockAndUpdate(pPos, (BlockState)pLevel.getBlockState(pPos).setValue((Property)LIGHT, (Comparable)Integer.valueOf(newLight)));
        }
        pLevel.scheduleTick(pPos, (Block)this, 100);
    }
}

