/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.block.custom;

import net.farkas.wildaside.block.ModBlocks;
import net.farkas.wildaside.block.custom.EntoriumOre;
import net.farkas.wildaside.particle.ModParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class OvergrownEntoriumOre
extends EntoriumOre {
    public OvergrownEntoriumOre(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        if (pLevel.isClientSide || pHand == InteractionHand.OFF_HAND) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ItemStack playerItem = pPlayer.getItemInHand(pHand);
        if (playerItem.getItem() == Items.SHEARS) {
            BlockState newBlock = ((Block)ModBlocks.ENTORIUM_ORE.get()).defaultBlockState();
            pLevel.setBlock(pPos, newBlock, 3);
            pLevel.playSound(null, pPos, SoundEvents.MOOSHROOM_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
            pPlayer.swing(pHand);
            if (!pPlayer.isInvulnerable()) {
                playerItem.hurtAndBreak(1, (LivingEntity)pPlayer, pStack.getEquipmentSlot());
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if ((double)pRandom.nextFloat() < 0.5) {
            pLevel.addParticle((ParticleOptions)ModParticles.ENTORIUM_PARTICLE.get(), (double)((float)pPos.getX() + pRandom.nextFloat()), (double)(pPos.getY() + 1), (double)((float)pPos.getZ() + pRandom.nextFloat()), 0.0, 0.0, 0.0);
            super.animateTick(pState, pLevel, pPos, pRandom);
        }
    }
}

