/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.block.custom;

import net.farkas.wildaside.block.custom.SubstiliumSoil;
import net.farkas.wildaside.util.EnchantmentUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class SubstiliumRedstoneOre
extends SubstiliumSoil {
    public static final BooleanProperty LIT = RedstoneTorchBlock.LIT;

    public SubstiliumRedstoneOre(IntProvider p_221084_, BlockBehaviour.Properties p_221083_) {
        super(p_221084_, p_221083_);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public void attack(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        SubstiliumRedstoneOre.interact(pState, pLevel, pPos);
        super.attack(pState, pLevel, pPos, pPlayer);
    }

    public void stepOn(Level pLevel, BlockPos pPos, BlockState pState, Entity pEntity) {
        if (!pEntity.isSteppingCarefully()) {
            SubstiliumRedstoneOre.interact(pState, pLevel, pPos);
        }
        super.stepOn(pLevel, pPos, pState, pEntity);
    }

    public InteractionResult use(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.isClientSide) {
            SubstiliumRedstoneOre.spawnParticles(pLevel, pPos);
        } else {
            SubstiliumRedstoneOre.interact(pState, pLevel, pPos);
        }
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        return itemstack.getItem() instanceof BlockItem && new BlockPlaceContext(pPlayer, pHand, itemstack, pHit).canPlace() ? InteractionResult.PASS : InteractionResult.SUCCESS;
    }

    private static void interact(BlockState pState, Level pLevel, BlockPos pPos) {
        SubstiliumRedstoneOre.spawnParticles(pLevel, pPos);
        if (!((Boolean)pState.getValue((Property)LIT)).booleanValue()) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public boolean isRandomlyTicking(BlockState pState) {
        return (Boolean)pState.getValue((Property)LIT);
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (((Boolean)pState.getValue((Property)LIT)).booleanValue()) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public void spawnAfterBreak(BlockState pState, ServerLevel pLevel, BlockPos pPos, ItemStack pStack, boolean pDropExperience) {
        super.spawnAfterBreak(pState, pLevel, pPos, pStack, pDropExperience);
    }

    public int getExpDrop(BlockState state, LevelAccessor level, BlockPos pos, @Nullable BlockEntity blockEntity, @Nullable Entity breaker, ItemStack tool) {
        return tool.getEnchantmentLevel(EnchantmentUtils.getEnchtantmentHolder(level, (ResourceKey<Enchantment>)Enchantments.SILK_TOUCH)) == 0 ? 1 + level.getRandom().nextInt(5) : 0;
    }

    @Override
    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (((Boolean)pState.getValue((Property)LIT)).booleanValue()) {
            SubstiliumRedstoneOre.spawnParticles(pLevel, pPos);
        }
    }

    private static void spawnParticles(Level pLevel, BlockPos pPos) {
        double d0 = 0.5625;
        RandomSource randomsource = pLevel.random;
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = pPos.relative(direction);
            if (pLevel.getBlockState(blockpos).isSolidRender((BlockGetter)pLevel, blockpos)) continue;
            Direction.Axis direction$axis = direction.getAxis();
            double d1 = direction$axis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.getStepX() : (double)randomsource.nextFloat();
            double d2 = direction$axis == Direction.Axis.Y ? 0.5 + 0.5625 * (double)direction.getStepY() : (double)randomsource.nextFloat();
            double d3 = direction$axis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.getStepZ() : (double)randomsource.nextFloat();
            pLevel.addParticle((ParticleOptions)DustParticleOptions.REDSTONE, (double)pPos.getX() + d1, (double)pPos.getY() + d2, (double)pPos.getZ() + d3, 0.0, 0.0, 0.0);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{LIT});
    }
}

