/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.block.custom.vibrion;

import net.farkas.wildaside.block.entity.NaturalSporeBlasterBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class NaturalSporeBlaster
extends RotatedPillarBlock
implements EntityBlock {
    public NaturalSporeBlaster(BlockBehaviour.Properties props) {
        super(props);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        return true;
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)AXIS, (Comparable)pContext.getNearestLookingDirection().getOpposite().getAxis());
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block neighbor, BlockPos neighborPos, boolean moved) {
        if (!world.isClientSide) {
            world.scheduleTick(pos, (Block)this, 2);
        }
        super.neighborChanged(state, world, pos, neighbor, neighborPos, moved);
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean moved) {
        if (!world.isClientSide) {
            world.scheduleTick(pos, (Block)this, 2);
        }
        super.onPlace(state, world, pos, oldState, moved);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof NaturalSporeBlasterBlockEntity) {
            NaturalSporeBlasterBlockEntity sbe = (NaturalSporeBlasterBlockEntity)blockEntity;
            sbe.tickServer();
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new NaturalSporeBlasterBlockEntity(pos, state);
    }
}

