/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.block.custom.vibrion;

import net.farkas.wildaside.particle.ModParticles;
import net.farkas.wildaside.util.ContaminationHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.pathfinder.PathType;
import org.jetbrains.annotations.Nullable;

public class SporeAir
extends AirBlock {
    private int AGE = 0;
    public static final DirectionProperty FACING = DirectionalBlock.FACING;

    public SporeAir(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        super.entityInside(pState, pLevel, pPos, pEntity);
        if (!pLevel.isClientSide()) {
            ContaminationHandler.addDose(pEntity, 50);
        }
    }

    @Nullable
    public PathType getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return PathType.DANGER_OTHER;
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        if (!pLevel.isClientSide) {
            pLevel.scheduleTick(pPos, (Block)this, 20);
        }
        super.onPlace(pState, pLevel, pPos, pOldState, pMovedByPiston);
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        this.AGE += pRandom.nextInt(1, 2);
        if (this.AGE > 4) {
            pLevel.removeBlock(pPos, false);
        }
        pLevel.scheduleTick(pPos, (Block)this, 20);
        super.tick(pState, pLevel, pPos, pRandom);
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        for (int i = 0; i < pRandom.nextInt(5, 10); ++i) {
            pLevel.addParticle((ParticleOptions)ModParticles.VIBRION_PARTICLE.get(), (double)((float)pPos.getX() + pRandom.nextFloat()), (double)((float)pPos.getY() + pRandom.nextFloat()), (double)((float)pPos.getZ() + pRandom.nextFloat()), 0.0, 0.0, 0.0);
        }
        super.animateTick(pState, pLevel, pPos, pRandom);
    }
}

