/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.block.entity;

import java.util.List;
import java.util.Optional;
import net.farkas.wildaside.block.entity.ModBlockEntities;
import net.farkas.wildaside.recipe.BioengineeringWorkstationRecipe;
import net.farkas.wildaside.recipe.BioengineeringWorkstationRecipeInput;
import net.farkas.wildaside.recipe.ModRecipes;
import net.farkas.wildaside.screen.bioengineering_workstation.BioengineeringWorkstationMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class BioengineeringWorkstationBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler itemHandler = new ItemStackHandler(6){

        protected void onContentsChanged(int slot) {
            BioengineeringWorkstationBlockEntity.this.setChanged();
            if (!((BioengineeringWorkstationBlockEntity)BioengineeringWorkstationBlockEntity.this).level.isClientSide) {
                BioengineeringWorkstationBlockEntity.this.level.sendBlockUpdated(BioengineeringWorkstationBlockEntity.this.getBlockPos(), BioengineeringWorkstationBlockEntity.this.getBlockState(), BioengineeringWorkstationBlockEntity.this.getBlockState(), 3);
            }
        }
    };
    private static final int INPUT_1 = 0;
    private static final int INPUT_2 = 1;
    private static final int INPUT_3 = 2;
    private static final int INPUT_4 = 3;
    private static final int INPUT_5 = 4;
    private static final int OUTPUT_1 = 5;
    protected final ContainerData data = new ContainerData(){

        public int get(int pIndex) {
            return switch (pIndex) {
                case 0 -> BioengineeringWorkstationBlockEntity.this.progress;
                case 1 -> BioengineeringWorkstationBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void set(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    BioengineeringWorkstationBlockEntity.this.progress = pValue;
                    break;
                }
                case 1: {
                    BioengineeringWorkstationBlockEntity.this.maxProgress = pValue;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 200;

    public BioengineeringWorkstationBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntities.BIOENGINEERING_WORKSTATION.get(), pPos, pBlockState);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.wildaside.bioengineering_workstation");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new BioengineeringWorkstationMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        pTag.put("inventory", (Tag)this.itemHandler.serializeNBT(pRegistries));
        pTag.putInt("bioengineering_workstation.progress", this.progress);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.itemHandler.deserializeNBT(pRegistries, pTag.getCompound("inventory"));
        this.progress = pTag.getInt("bioengineering_workstation.progress");
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (this.hasRecipe()) {
            this.increaseCraftingProgress();
            BioengineeringWorkstationBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            if (this.hasProgressFinished()) {
                this.craftItem();
                this.resetProgress();
            }
        } else {
            this.resetProgress();
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem() {
        Optional<RecipeHolder<BioengineeringWorkstationRecipe>> recipe = this.getCurrentRecipe();
        ItemStack result = ((BioengineeringWorkstationRecipe)recipe.get().value()).output();
        this.itemHandler.extractItem(0, 1, false);
        this.itemHandler.extractItem(1, 1, false);
        this.itemHandler.extractItem(2, 1, false);
        this.itemHandler.extractItem(3, 1, false);
        this.itemHandler.extractItem(4, 1, false);
        this.itemHandler.setStackInSlot(5, new ItemStack((ItemLike)result.getItem(), this.itemHandler.getStackInSlot(5).getCount() + result.getCount()));
    }

    private boolean hasRecipe() {
        Optional<RecipeHolder<BioengineeringWorkstationRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack result = ((BioengineeringWorkstationRecipe)recipe.get().value()).output();
        return this.canInsertAmountIntoOutputSlot(result.getCount()) && this.canInsertItemIntoOutputSlot(result.getItem());
    }

    private Optional<RecipeHolder<BioengineeringWorkstationRecipe>> getCurrentRecipe() {
        List<ItemStack> list = List.of(this.itemHandler.getStackInSlot(0), this.itemHandler.getStackInSlot(1), this.itemHandler.getStackInSlot(2), this.itemHandler.getStackInSlot(3), this.itemHandler.getStackInSlot(4));
        return this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.BIOENGINEERING_TYPE.get(), (RecipeInput)new BioengineeringWorkstationRecipeInput(list), this.level);
    }

    private boolean canInsertItemIntoOutputSlot(Item item) {
        return this.itemHandler.getStackInSlot(5).isEmpty() || this.itemHandler.getStackInSlot(5).is(item);
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        int maxCount = this.itemHandler.getStackInSlot(5).isEmpty() ? 64 : this.itemHandler.getStackInSlot(5).getMaxStackSize();
        int currentCount = this.itemHandler.getStackInSlot(5).getCount();
        return maxCount >= currentCount + count;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }
}

