/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.block.entity;

import java.util.List;
import net.farkas.wildaside.block.custom.vibrion.WindBlaster;
import net.farkas.wildaside.block.entity.BlasterBlockEntity;
import net.farkas.wildaside.block.entity.ModBlockEntities;
import net.farkas.wildaside.particle.ModParticles;
import net.farkas.wildaside.util.BlasterUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WindBlasterBlockEntity
extends BlasterBlockEntity {
    private static final int MAX_RANGE = 15;
    private static final double BASE_FORCE = 0.15;
    private BlockPos previousPos = BlockPos.ZERO;
    private int blocksTraveled = 0;

    public WindBlasterBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.WIND_BLASTER.get(), pos, state);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
    }

    public void tickServer(Level level, BlockPos origin, BlockState oldState) {
        double particleInterval;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)level;
        Direction facing = (Direction)this.getBlockState().getValue((Property)WindBlaster.FACING);
        Direction back = facing.getOpposite();
        int rangeSignal = world.getSignal(this.worldPosition.relative(back), back);
        int strength = 1;
        for (Direction dir : Direction.values()) {
            if (dir == back) continue;
            strength = Math.max(strength, world.getSignal(this.worldPosition.relative(dir), dir));
        }
        if (rangeSignal <= 0) {
            return;
        }
        int range = Mth.clamp((int)rangeSignal, (int)1, (int)15);
        double force = 0.15 * ((double)strength / 15.0);
        RandomSource rand = world.random;
        SimpleParticleType particle = ModParticles.LIFESTEAL_PARTICLE.get();
        Vec3 start = Vec3.atCenterOf((Vec3i)this.worldPosition);
        double step = 0.1;
        double nextParticle = particleInterval = 0.7;
        for (double traveled = 0.8; traveled <= (double)range; traveled += step) {
            Vec3 sample = start.add((double)facing.getStepX() * traveled, (double)facing.getStepY() * traveled, (double)facing.getStepZ() * traveled);
            BlockPos samplePos = BlockPos.containing((Position)sample);
            BlockState state = world.getBlockState(samplePos);
            if (this.previousPos != samplePos) {
                this.previousPos = samplePos;
                if (this.shouldBreakNext) {
                    this.shouldBreakNext = false;
                    break;
                }
            }
            if (state.isCollisionShapeFullBlock((BlockGetter)world, samplePos)) break;
            if (!BlasterUtils.canTraverse(facing, state, oldState, this)) {
                this.blocksTraveled = Math.abs(origin.getX() - samplePos.getX()) + Math.abs(origin.getY() - samplePos.getY()) + Math.abs(origin.getZ() - samplePos.getZ());
                if (strength - this.blocksTraveled < 7) break;
                BlockState openableBlockState = level.getBlockState(samplePos);
                if (openableBlockState.hasProperty((Property)BlockStateProperties.OPEN)) {
                    level.setBlock(samplePos, (BlockState)openableBlockState.setValue((Property)DoorBlock.OPEN, (Comparable)Boolean.valueOf((Boolean)openableBlockState.getValue((Property)DoorBlock.OPEN) == false)), 3);
                    this.shouldBreakNext = false;
                }
            }
            if (traveled >= nextParticle) {
                nextParticle += particleInterval;
                float density = (float)((0.2 + (double)strength / 15.0) * Math.exp(-0.3 * traveled));
                if (rand.nextFloat() < density) {
                    double radius = 0.25 + 0.1 * ((double)strength / 15.0);
                    double offsetX = (rand.nextDouble() - 0.5) * 2.0 * radius;
                    double offsetY = (rand.nextDouble() - 0.5) * 2.0 * radius;
                    double offsetZ = (rand.nextDouble() - 0.5) * 2.0 * radius;
                    if (facing.getAxis() == Direction.Axis.X) {
                        offsetX = 0.0;
                    } else if (facing.getAxis() == Direction.Axis.Y) {
                        offsetY = 0.0;
                    } else {
                        offsetZ = 0.0;
                    }
                    Vec3 particlePos = sample.add(offsetX, offsetY, offsetZ);
                    double speed = 0.05 + 0.15 * (force / 0.15);
                    if (rand.nextFloat() < 0.8f) {
                        world.sendParticles((ParticleOptions)ModParticles.LIFESTEAL_PARTICLE.get(), particlePos.x, particlePos.y, particlePos.z, 1, (double)facing.getStepX() * speed, (double)facing.getStepY() * speed, (double)facing.getStepZ() * speed, 0.0);
                    }
                    if (rand.nextFloat() < 0.2f) {
                        world.sendParticles((ParticleOptions)ParticleTypes.POOF, particlePos.x, particlePos.y, particlePos.z, 1, (double)facing.getStepX() * 0.02, (double)facing.getStepY() * 0.02, (double)facing.getStepZ() * 0.02, 0.0);
                    }
                }
            }
            double falloff = Math.exp(-0.25 * traveled);
            double appliedForce = force * falloff;
            AABB box = new AABB(samplePos).inflate(-0.05);
            List entities = world.getEntities((Entity)null, box, e -> true);
            for (Entity e2 : entities) {
                if (e2 instanceof ArmorStand || this.isHeavyEntity(e2)) continue;
                Vec3 velocity = e2.getDeltaMovement();
                if (velocity.y < -0.08 && facing.getStepY() > 0) {
                    double fallSpeed = Math.abs(velocity.y);
                    double lift = Math.min(fallSpeed * 0.25 * ((double)strength / 15.0), 0.12);
                    velocity = velocity.add(0.0, lift, 0.0);
                }
                Vec3 push = new Vec3((double)facing.getStepX(), (double)facing.getStepY(), (double)facing.getStepZ());
                velocity = velocity.add(push.scale(appliedForce));
                double maxSpeed = 1.5;
                double hor = Math.sqrt(velocity.x * velocity.x + velocity.z * velocity.z);
                if (hor > maxSpeed) {
                    double scale = maxSpeed / hor;
                    velocity = new Vec3(velocity.x * scale, velocity.y, velocity.z * scale);
                }
                e2.setDeltaMovement(velocity);
                e2.hurtMarked = true;
            }
        }
    }

    private boolean isHeavyEntity(Entity e) {
        return e instanceof IronGolem || e instanceof Ravager || e instanceof WitherBoss || e instanceof EnderDragon;
    }
}

