/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import net.farkas.wildaside.network.WindData;
import net.farkas.wildaside.network.WindSavedData;
import net.farkas.wildaside.util.ContaminationHandler;
import net.farkas.wildaside.util.WindManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class ModCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)Commands.literal((String)"wildaside").requires(cs -> cs.hasPermission(2));
        root.then(Commands.literal((String)"contamination").then(Commands.argument((String)"action", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest((String[])new String[]{"add", "get", "set", "clear"}, (SuggestionsBuilder)builder)).then(((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> ModCommands.executeContamination((CommandContext<CommandSourceStack>)ctx, true)))).executes(ctx -> ModCommands.executeContamination((CommandContext<CommandSourceStack>)ctx, false)))));
        root.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"wind").then(Commands.literal((String)"set").then(Commands.argument((String)"x", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.argument((String)"y", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.argument((String)"z", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.argument((String)"strength", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(ctx -> {
            double x = DoubleArgumentType.getDouble((CommandContext)ctx, (String)"x");
            double y = DoubleArgumentType.getDouble((CommandContext)ctx, (String)"y");
            double z = DoubleArgumentType.getDouble((CommandContext)ctx, (String)"z");
            float s = FloatArgumentType.getFloat((CommandContext)ctx, (String)"strength");
            Vec3 vec = new Vec3(x, y, z);
            WindManager.setWind(vec, s);
            ServerLevel serverLevel = ((CommandSourceStack)ctx.getSource()).getLevel();
            WindSavedData windSavedData = WindSavedData.get(serverLevel);
            windSavedData.setWeather(serverLevel.isRaining(), serverLevel.isThundering());
            windSavedData.setWind(vec, s);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Set wind to (" + x + ", " + y + ", " + z + ") strength=" + s)), true);
            return 1;
        }))))))).then(Commands.literal((String)"random").executes(ctx -> {
            ServerLevel serverLevel = ((CommandSourceStack)ctx.getSource()).getLevel();
            WindData windData = WindManager.calculateAndSetWind(serverLevel, true);
            Vec3 dir = windData.direction();
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Set random wind to (" + dir.x + ", " + dir.y + ", " + dir.z + ") strength=" + windData.strength())), true);
            return 1;
        }))).then(Commands.literal((String)"get").executes(ctx -> {
            float strength = WindManager.getStrength();
            Vec3 dir = WindManager.getDirection();
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Current wind: (" + dir.x + ", " + dir.y + ", " + dir.z + ") strength=" + strength)), false);
            return 1;
        })));
        dispatcher.register(root);
    }

    private static int executeContamination(CommandContext<CommandSourceStack> ctx, boolean hasAmount) throws CommandSyntaxException {
        String action = StringArgumentType.getString(ctx, (String)"action");
        Collection targets = EntityArgument.getEntities(ctx, (String)"targets");
        int amount = hasAmount ? IntegerArgumentType.getInteger(ctx, (String)"amount") : 0;
        int affected = 0;
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        block12: for (Entity entity : targets) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            switch (action.toLowerCase()) {
                case "add": {
                    ContaminationHandler.addDose((Entity)living, amount);
                    source.sendSuccess(() -> Component.literal((String)("Added " + amount + " of contamination to " + living.getName().getString())), false);
                    ++affected;
                    continue block12;
                }
                case "get": {
                    int current = ContaminationHandler.getDose((Entity)living);
                    source.sendSuccess(() -> Component.literal((String)(living.getName().getString() + " has " + current + " contamination")), false);
                    ++affected;
                    continue block12;
                }
                case "set": {
                    ContaminationHandler.setDose((Entity)living, amount);
                    source.sendSuccess(() -> Component.literal((String)("Set contamination of " + living.getName().getString() + " to " + amount)), false);
                    ++affected;
                    continue block12;
                }
                case "clear": {
                    ContaminationHandler.setDose((Entity)living, 0);
                    source.sendSuccess(() -> Component.literal((String)("Cleared contamination of " + living.getName().getString())), false);
                    ++affected;
                    continue block12;
                }
            }
            source.sendFailure((Component)Component.literal((String)("Invalid action: " + action)));
            return 0;
        }
        if (affected > 0) {
            String entityString = affected > 1 ? "entities" : "entity";
            int finalAffected = affected;
            source.sendSuccess(() -> Component.literal((String)("Applied '" + action + "' to " + finalAffected + " " + entityString)), true);
        } else {
            source.sendFailure((Component)Component.literal((String)"No valid living entities found."));
        }
        return affected;
    }
}

