/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.effect.custom;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.farkas.wildaside.effect.ModMobEffects;
import net.farkas.wildaside.particle.ModParticles;
import net.farkas.wildaside.util.AdvancementHandler;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber(modid="wildaside")
class LifestealHandler {
    private static final List<Task> TASKS = new LinkedList<Task>();

    LifestealHandler() {
    }

    @SubscribeEvent
    public static void applyLifesteal(LivingIncomingDamageEvent event) {
        DamageSource src = event.getSource();
        Entity entity = src.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        MobEffectInstance lifesteal = attacker.getEffect(ModMobEffects.LIFESTEAL.getDelegate());
        if (lifesteal == null) {
            return;
        }
        float perc = (float)(lifesteal.getAmplifier() + 1) / 10.0f;
        float max = (float)(lifesteal.getAmplifier() + 1) * 3.0f;
        float heal = event.getAmount() * perc;
        if (heal > max) {
            heal = max;
        }
        LivingEntity target = event.getEntity();
        Level level = attacker.level();
        if (level instanceof ServerLevel) {
            ServerLevel lvl = (ServerLevel)level;
            double dist = attacker.distanceTo((Entity)target);
            int delay = Mth.ceil((double)(dist * 4.0));
            TASKS.add(new Task(lvl, attacker.getUUID(), target.getUUID(), heal, delay));
        }
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Pre event) {
        Iterator<Task> it = TASKS.iterator();
        while (it.hasNext()) {
            LivingEntity a;
            Entity target;
            Task t;
            block6: {
                block5: {
                    t = it.next();
                    Entity attacker = t.level.getEntity(t.attackerId);
                    target = t.level.getEntity(t.targetId);
                    if (!(attacker instanceof LivingEntity)) break block5;
                    a = (LivingEntity)attacker;
                    if (target instanceof LivingEntity) break block6;
                }
                it.remove();
                continue;
            }
            LivingEntity b = (LivingEntity)target;
            double ax = a.getX();
            double ay = a.getY() + (double)a.getBbHeight() * 0.5;
            double az = a.getZ();
            double tx = b.getX();
            double ty = b.getY() + (double)b.getBbHeight() * 0.5;
            double tz = b.getZ();
            double prog = (double)t.ticksElapsed / (double)t.totalTicks;
            double px = Mth.lerp((double)prog, (double)tx, (double)ax);
            double py = Mth.lerp((double)prog, (double)ty, (double)ay);
            double pz = Mth.lerp((double)prog, (double)tz, (double)az);
            t.level.sendParticles((ParticleOptions)ModParticles.LIFESTEAL_PARTICLE.get(), px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
            ++t.ticksElapsed;
            if (t.ticksElapsed < t.totalTicks) continue;
            if (a instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)a;
                AdvancementHandler.givePlayerAdvancement((Entity)serverPlayer, "life_leech");
            }
            a.heal(t.healAmount);
            it.remove();
        }
    }

    private static class Task {
        final ServerLevel level;
        final UUID attackerId;
        final UUID targetId;
        final float healAmount;
        final int totalTicks;
        int ticksElapsed = 0;

        Task(ServerLevel level, UUID attackerId, UUID targetId, float healAmount, int totalTicks) {
            this.level = level;
            this.attackerId = attackerId;
            this.targetId = targetId;
            this.healAmount = healAmount;
            this.totalTicks = totalTicks;
        }
    }
}

