/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.entity.ai.mucellith;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.farkas.wildaside.entity.custom.vibrion.MucellithEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;

public class MucellithAttackGoal
extends Goal {
    private static final int WINDUP_DURATION = 7;
    private final Mob mob;
    private final MucellithEntity entity;
    @Nullable
    private LivingEntity target;
    private int attackTime = 60;
    private final int attackTimeMax;
    private final float attackRadius;
    private int windupTicks;

    public MucellithAttackGoal(MucellithEntity entity, int pAttackInterval, float pAttackRadius) {
        this.entity = entity;
        this.mob = entity;
        this.attackTimeMax = pAttackInterval;
        this.attackRadius = pAttackRadius;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.entity.isDefending()) {
            return false;
        }
        LivingEntity livingentity = this.mob.getTarget();
        if (livingentity != null && livingentity.isAlive() && !(livingentity instanceof MucellithEntity)) {
            this.target = livingentity;
            return true;
        }
        return false;
    }

    public void stop() {
        this.entity.setAttacking(false);
        this.attackTime = this.attackTimeMax;
        this.target = null;
    }

    public void start() {
        this.attackTime = this.attackTimeMax;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        Player player;
        LivingEntity livingEntity = this.target;
        if (livingEntity instanceof Player && (player = (Player)livingEntity).isInvulnerable()) {
            this.target = null;
        }
        if (this.target == null) {
            this.stop();
            return;
        }
        this.shoot();
    }

    public void shoot() {
        --this.attackTime;
        this.mob.getLookControl().setLookAt((Entity)this.target, 30.0f, 30.0f);
        if (this.attackTime <= 0) {
            if (!this.mob.getSensing().hasLineOfSight((Entity)this.target)) {
                return;
            }
            this.entity.setAttacking(true);
            this.entity.attackAnimation.start(this.entity.tickCount);
            this.entity.attackAnimationTimeout = this.entity.attackAnimationMax;
            this.attackTime = this.attackTimeMax;
            this.windupTicks = 7;
        }
        if (this.windupTicks > 0) {
            --this.windupTicks;
            if (this.windupTicks == 0) {
                float dist = (float)Math.sqrt(this.mob.distanceToSqr((Entity)this.target)) / this.attackRadius;
                float power = Mth.clamp((float)dist, (float)0.1f, (float)1.0f);
                this.entity.performRangedAttack(this.target, power);
            }
        }
        if (this.entity.isAttacking() && --this.entity.attackAnimationTimeout <= 0) {
            this.entity.attackAnimation.stop();
            this.entity.setAttacking(false);
        }
    }
}

