/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.entity.custom.vibrion;

import net.farkas.wildaside.effect.ModMobEffects;
import net.farkas.wildaside.entity.ai.mucellith.MucellithAttackGoal;
import net.farkas.wildaside.entity.ai.mucellith.MucellithLookAtPlayerGoal;
import net.farkas.wildaside.entity.ai.mucellith.MucellithRandomLookAroundGoal;
import net.farkas.wildaside.entity.custom.vibrion.SporeBombEntity;
import net.farkas.wildaside.sound.ModSounds;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class MucellithEntity
extends PathfinderMob
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.defineId(MucellithEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DEFENDING = SynchedEntityData.defineId(MucellithEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAS_DEFENDED = SynchedEntityData.defineId(MucellithEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int soundCooldown = 0;
    private final int soundCooldownMax = 20;
    public final int attackAnimationMax = 60;
    public int attackAnimationTimeout = 0;
    public final AnimationState idleAnimation = new AnimationState();
    public final AnimationState attackAnimation = new AnimationState();
    public final AnimationState defenseAnimation = new AnimationState();
    public final AnimationState defenseAnimationReverse = new AnimationState();

    public MucellithEntity(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new MucellithAttackGoal(this, 60, 8.0f));
        this.goalSelector.addGoal(2, (Goal)new MucellithLookAtPlayerGoal(this, Player.class, 64.0f));
        this.goalSelector.addGoal(4, (Goal)new MucellithRandomLookAroundGoal(this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, entity -> entity.hasEffect(ModMobEffects.CONTAMINATION.getDelegate()) && !(entity instanceof MucellithEntity)));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, entity -> entity.hasEffect(ModMobEffects.CONTAMINATION.getDelegate()) && !(entity instanceof MucellithEntity)));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return PathfinderMob.createLivingAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.JUMP_STRENGTH, 0.0).add(Attributes.FLYING_SPEED, 0.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
    }

    public void aiStep() {
        super.aiStep();
        if (this.belowHealthThreshold(0.25f) && !this.hasDefended()) {
            this.setDefending(true);
            this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, -1, 6, false, true));
            this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, -1, 1, false, true));
        }
        if (this.isDefending()) {
            if (this.soundCooldown <= 0) {
                this.playSound(SoundEvents.WARDEN_HEARTBEAT, 1.0f, 1.5f);
                this.soundCooldown = 20;
            } else {
                --this.soundCooldown;
            }
            if (!this.belowHealthThreshold(0.5f)) {
                this.playSound(SoundEvents.WARDEN_ANGRY, 1.0f, 1.5f);
                this.setHasDefended(true);
                this.setDefending(false);
            }
        } else {
            this.removeEffect(MobEffects.DAMAGE_RESISTANCE);
            this.removeEffect(MobEffects.REGENERATION);
        }
    }

    private void setupAnimationStates() {
        if (this.isDefending()) {
            if (!this.defenseAnimation.isStarted()) {
                this.defenseAnimation.start(this.tickCount);
            }
        } else {
            this.defenseAnimation.stop();
            if (this.hasDefended()) {
                if (!this.defenseAnimationReverse.isStarted()) {
                    this.defenseAnimationReverse.start(this.tickCount);
                }
            } else {
                this.defenseAnimationReverse.stop();
            }
            if (!this.isAttacking()) {
                if (!this.idleAnimation.isStarted()) {
                    this.idleAnimation.start(this.tickCount);
                }
            } else {
                this.idleAnimation.stop();
            }
        }
        if (this.isAttacking()) {
            if (!this.attackAnimation.isStarted()) {
                this.attackAnimation.start(this.tickCount);
            }
        } else {
            this.attackAnimation.stop();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(ATTACKING, (Object)false);
        pBuilder.define(DEFENDING, (Object)false);
        pBuilder.define(HAS_DEFENDED, (Object)false);
    }

    public void performRangedAttack(LivingEntity pTarget, float pVelocity) {
        this.attackAnimation.start(0);
        SporeBombEntity sporeBomb = new SporeBombEntity(this.level(), (LivingEntity)this, this.random.nextFloat());
        double d0 = pTarget.getEyeY() - (double)1.1f;
        double d1 = pTarget.getX() - this.getX();
        double d2 = d0 - sporeBomb.getY() - 0.5;
        double d3 = pTarget.getZ() - this.getZ();
        double d4 = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
        sporeBomb.shoot(d1, d2 + d4, d3, 1.6f, 2.0f);
        this.playSound(SoundEvents.SNOWBALL_THROW, 1.0f, 0.2f);
        this.level().addFreshEntity((Entity)sporeBomb);
    }

    public void push(Entity pEntity) {
    }

    public void push(double pX, double pY, double pZ) {
    }

    public boolean isPushable() {
        return false;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public boolean ignoreExplosion(Explosion pExplosion) {
        return true;
    }

    public void setAttacking(boolean attacking) {
        this.entityData.set(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.entityData.get(ATTACKING);
    }

    public void setDefending(boolean defending) {
        this.entityData.set(DEFENDING, (Object)defending);
    }

    public boolean isDefending() {
        return (Boolean)this.entityData.get(DEFENDING);
    }

    public void setHasDefended(boolean hasDefended) {
        this.entityData.set(HAS_DEFENDED, (Object)hasDefended);
    }

    public boolean hasDefended() {
        return (Boolean)this.entityData.get(HAS_DEFENDED);
    }

    public boolean belowHealthThreshold(float threshold) {
        return this.getHealth() / this.getMaxHealth() <= threshold;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return ModSounds.MUCELLITH_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return ModSounds.MUCELLITH_HURT.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return ModSounds.MUCELLITH_DEATH.get();
    }
}

