/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.entity.custom.vibrion;

import java.util.List;
import net.farkas.wildaside.entity.ModEntities;
import net.farkas.wildaside.item.ModItems;
import net.farkas.wildaside.particle.ModParticles;
import net.farkas.wildaside.util.AdvancementHandler;
import net.farkas.wildaside.util.ContaminationHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class SporeBombEntity
extends ThrowableItemProjectile {
    private final float charge;

    public SporeBombEntity(EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.charge = this.level().random.nextFloat();
    }

    public SporeBombEntity(Level pLevel, LivingEntity livingEntity, float charge) {
        super(ModEntities.SPORE_BOMB.get(), livingEntity, pLevel);
        this.charge = charge;
    }

    public SporeBombEntity(Level pLevel, double x, double y, double z) {
        super(ModEntities.SPORE_BOMB.get(), x, y, z, pLevel);
        this.charge = this.level().random.nextFloat();
    }

    public SporeBombEntity(Level pLevel) {
        super(ModEntities.SPORE_BOMB.get(), pLevel);
        this.charge = this.level().random.nextFloat();
    }

    protected Item getDefaultItem() {
        return (Item)ModItems.SPORE_BOMB.get();
    }

    protected void onHitEntity(EntityHitResult pResult) {
        Level level = this.level();
        if (!level.isClientSide) {
            pResult.getEntity().hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 2.0f);
            this.applySporeCloud((ServerLevel)level, pResult.getEntity().blockPosition(), this.charge);
            this.discard();
        }
    }

    protected void onHitBlock(BlockHitResult pResult) {
        Level level = this.level();
        if (!level.isClientSide) {
            level.broadcastEntityEvent((Entity)this, (byte)3);
            BlockPos position = this.blockPosition();
            this.applySporeCloud((ServerLevel)level, position, this.charge);
        }
        this.discard();
        super.onHitBlock(pResult);
    }

    private void applySporeCloud(ServerLevel level, BlockPos center, float charge) {
        int radius = Mth.ceil((float)(1.0f + charge * 4.0f));
        RandomSource random = level.getRandom();
        SimpleParticleType particle = ModParticles.VIBRION_PARTICLE.get();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    if (dx * dx + dy * dy + dz * dz > radius * radius) continue;
                    for (int i = 0; i < 3; ++i) {
                        double x = (double)center.getX() + 0.5 + (double)dx + (random.nextDouble() - 0.5);
                        double y = (double)center.getY() + 0.5 + (double)dy + (random.nextDouble() - 0.5);
                        double z = (double)center.getZ() + 0.5 + (double)dz + (random.nextDouble() - 0.5);
                        level.sendParticles((ParticleOptions)particle, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
        AABB box = new AABB(center).inflate((double)radius);
        List list = level.getEntitiesOfClass(LivingEntity.class, box, e -> !e.isSpectator());
        int entityCount = 0;
        for (LivingEntity entity : list) {
            ++entityCount;
            ContaminationHandler.addDose((Entity)entity, Math.round((1.0f + charge / 2.0f) * 1000.0f));
            level.sendParticles((ParticleOptions)particle, entity.getX(), entity.getY() + 0.5, entity.getZ(), 5, 0.2, 0.2, 0.2, 0.01);
        }
        if (entityCount >= 5) {
            AdvancementHandler.givePlayerAdvancement(this.getOwner(), "weapons_of_mass_infection");
        }
    }
}

