/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.event;

import com.mojang.brigadier.CommandDispatcher;
import java.util.Optional;
import net.farkas.wildaside.attachments.ModAttachments;
import net.farkas.wildaside.attachments.contamination.ContaminationImplementation;
import net.farkas.wildaside.block.ModBlocks;
import net.farkas.wildaside.command.ModCommands;
import net.farkas.wildaside.effect.ModMobEffects;
import net.farkas.wildaside.entity.ModEntities;
import net.farkas.wildaside.entity.ModEntitySpawns;
import net.farkas.wildaside.entity.custom.hickory.HickoryTreantEntity;
import net.farkas.wildaside.entity.custom.vibrion.MucellithEntity;
import net.farkas.wildaside.item.ModItems;
import net.farkas.wildaside.network.WindSavedData;
import net.farkas.wildaside.potion.ModPotions;
import net.farkas.wildaside.util.AdvancementHandler;
import net.farkas.wildaside.util.ContaminationHandler;
import net.farkas.wildaside.util.WindManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.event.entity.living.LivingBreatheEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.CriticalHitEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber(modid="wildaside")
public class ModEvents {
    private static final ResourceLocation GLOWING_HICKORY_FOREST = ResourceLocation.fromNamespaceAndPath((String)"wildaside", (String)"glowing_hickory_forest");

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            AdvancementHandler.givePlayerAdvancement((Entity)player2, "wild_wilder_wildest");
        }
    }

    @SubscribeEvent
    public static void addPackFinders(AddPackFindersEvent event) {
        PackSelectionConfig config;
        ModContainer mod = ModList.get().getModContainerById("wildaside").orElse(null);
        if (mod == null || event.getPackType() != PackType.CLIENT_RESOURCES) {
            return;
        }
        String id = "wildaside_legacy";
        PathPackResources.PathResourcesSupplier supplier = new PathPackResources.PathResourcesSupplier(mod.getModInfo().getOwningFile().getFile().findResource(new String[]{"resourcepacks/" + id}));
        PackLocationInfo location = new PackLocationInfo(id, (Component)Component.literal((String)"Wild Aside Legacy"), PackSource.DEFAULT, Optional.empty());
        Pack pack = Pack.readMetaAndCreate((PackLocationInfo)location, (Pack.ResourcesSupplier)supplier, (PackType)PackType.CLIENT_RESOURCES, (PackSelectionConfig)(config = new PackSelectionConfig(false, Pack.Position.TOP, false)));
        if (pack != null) {
            event.addRepositorySource(consumer -> consumer.accept(pack));
        }
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put(ModEntities.MUCELLITH.get(), MucellithEntity.createAttributes().build());
        event.put(ModEntities.HICKORY_TREANT.get(), HickoryTreantEntity.createAttributes().build());
    }

    @SubscribeEvent
    public static void onRegisterSpawnPlacements(RegisterSpawnPlacementsEvent event) {
        ModEntitySpawns.registerSpawnPlacements(event);
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        ModCommands.register((CommandDispatcher<CommandSourceStack>)dispatcher);
    }

    @SubscribeEvent
    public static void brewingRecipesEvent(RegisterBrewingRecipesEvent event) {
        PotionBrewing.Builder builder = event.getBuilder();
        builder.addMix(Potions.AWKWARD, (Item)ModItems.MUCELLITH_JAW.get(), ModPotions.LIFESTEAL_POTION);
        builder.addMix(ModPotions.LIFESTEAL_POTION, Items.REDSTONE, ModPotions.LIFESTEAL_POTION_2);
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        ModEvents.loadWind(event);
    }

    public static void loadWind(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)levelAccessor;
        if (!serverLevel.dimension().equals(ServerLevel.OVERWORLD)) {
            return;
        }
        WindSavedData data = WindSavedData.get(serverLevel);
        Vec3 dir = data.getWindDirection();
        float strength = data.getWindStrength();
        WindManager.setWind(dir, strength);
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        ModEvents.manageWeather(event);
    }

    public static void manageWeather(ServerTickEvent.Post event) {
        MinecraftServer server = event.getServer();
        ServerLevel overworld = server.getLevel(Level.OVERWORLD);
        if (overworld == null) {
            return;
        }
        WindSavedData weatherData = WindSavedData.get(overworld);
        boolean raining = overworld.isRaining();
        boolean thundering = overworld.isThundering();
        if (raining != weatherData.wasRaining() || thundering != weatherData.wasThundering()) {
            WindManager.calculateAndSetWind(overworld, false);
        }
        int time = 1200;
        if (server.getTickCount() % time == 0) {
            WindManager.calculateAndSetWind(overworld, true);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Pre event) {
        if (event.getEntity().level().isClientSide) {
            return;
        }
        ModEvents.glowUpAdvancement(event);
        ModEvents.clipContextCheckingTickEvent((PlayerTickEvent)event);
    }

    private static void glowUpAdvancement(PlayerTickEvent.Pre event) {
        Holder biomeHolder;
        ResourceKey biomeKey;
        ServerPlayer player = (ServerPlayer)event.getEntity();
        ServerLevel world = player.serverLevel();
        long time = world.getDayTime();
        if (time >= 14000L && time <= 22000L && (biomeKey = (ResourceKey)(biomeHolder = world.getBiome(player.blockPosition())).unwrapKey().orElse(null)) != null && biomeKey.location().equals((Object)GLOWING_HICKORY_FOREST)) {
            AdvancementHandler.givePlayerAdvancement((Entity)player, "glow_up");
        }
    }

    private static void clipContextCheckingTickEvent(PlayerTickEvent event) {
        ClipContext clipContext;
        ServerPlayer player = (ServerPlayer)event.getEntity();
        ServerLevel level = player.serverLevel();
        BlockHitResult hitResult = level.clip(clipContext = new ClipContext(player.getEyePosition(1.0f), player.getEyePosition(1.0f).add(player.getViewVector(1.0f).scale(5.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        if (hitResult.getType() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult blockHit = hitResult;
        BlockPos blockPos = blockHit.getBlockPos();
        BlockState state = level.getBlockState(blockPos);
        if (state.is((Block)ModBlocks.OVERGROWN_ENTORIUM_ORE.get())) {
            AdvancementHandler.givePlayerAdvancement((Entity)player, "its_shearing_time");
        } else if (state.is((Block)ModBlocks.SPORE_BLASTER.get()) && level.getBestNeighborSignal(blockPos) > 0) {
            AdvancementHandler.givePlayerAdvancement((Entity)player, "bacteria_beacon");
        }
    }

    @SubscribeEvent
    public static void onBlockBroken(BlockEvent.BreakEvent event) {
        if (event.getPlayer().level().isClientSide) {
            return;
        }
        ModEvents.blasterBustedAdvancement(event);
    }

    public static void blasterBustedAdvancement(BlockEvent.BreakEvent event) {
        if (event.getLevel().getBlockState(event.getPos()).getBlock() == ModBlocks.NATURAL_SPORE_BLASTER.get()) {
            AdvancementHandler.givePlayerAdvancement((Entity)((ServerPlayer)event.getPlayer()), "blaster_busted");
        }
    }

    @SubscribeEvent
    public static void onMobEffectExpired(MobEffectEvent.Expired event) {
        if (event.getEntity().level().isClientSide) {
            return;
        }
        ModEvents.onContaminationEffectExpired(event);
    }

    public static void onContaminationEffectExpired(MobEffectEvent.Expired event) {
        LivingEntity entity = event.getEntity();
        MobEffectInstance mobEffectInstance = event.getEffectInstance();
        if (mobEffectInstance != null && mobEffectInstance.getEffect() == ModMobEffects.CONTAMINATION.getDelegate()) {
            Holder immunity = ModMobEffects.IMMUNITY.getDelegate();
            entity.addEffect(new MobEffectInstance(immunity, (mobEffectInstance.getAmplifier() + 1) * 5 * 20, mobEffectInstance.getAmplifier()));
        }
    }

    @SubscribeEvent
    public static void onCriticalHit(CriticalHitEvent event) {
        if (event.getEntity().level().isClientSide || !event.isCriticalHit()) {
            return;
        }
        ModEvents.spreadContaminationOnCriticalHit(event);
    }

    public static void spreadContaminationOnCriticalHit(CriticalHitEvent event) {
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        Holder contamEffect = ModMobEffects.CONTAMINATION.getDelegate();
        Player attacker = event.getEntity();
        if (attacker.hasEffect(contamEffect)) {
            Entity entity;
            RandomSource random = attacker.getRandom();
            if ((float)attacker.getEffect(contamEffect).getAmplifier() / 5.0f > random.nextFloat() && (entity = event.getTarget()) instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)entity;
                int dose = ((ContaminationImplementation)attacker.getData(ModAttachments.CONTAMINATION)).getDose();
                ContaminationHandler.addDose((Entity)target, dose / 5);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingBreathing(LivingBreatheEvent event) {
        if (event.getEntity().level().isClientSide) {
            return;
        }
        ModEvents.passiveContaminationDoseReduction(event);
    }

    public static void passiveContaminationDoseReduction(LivingBreatheEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.level().isClientSide()) {
            return;
        }
        ((ContaminationImplementation)entity.getData(ModAttachments.CONTAMINATION)).addDose(-10);
    }
}

