/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.particle.custom;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ModDripParticle
extends TextureSheetParticle {
    private final int hangTime = 60;
    private final int stretchTime = 30;
    private float stretchFactor = 0.0f;

    protected ModDripParticle(ClientLevel level, double x, double y, double z, SpriteSet spriteSet) {
        super(level, x, y, z);
        this.setSize(0.01f, 0.01f);
        this.lifetime = 150 + this.random.nextInt(20);
        this.gravity = 0.0f;
        this.pickSprite(spriteSet);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age < 60) {
            this.yd = 0.0;
            this.stretchFactor = 1.0f;
        } else if (this.age < 90) {
            this.gravity = 0.001f;
            float progress = (float)(this.age - 60) / 30.0f;
            this.yd = 0.0;
            this.stretchFactor = 1.0f + 1.5f * progress;
        } else {
            this.gravity = 0.05f;
        }
        this.yd -= (double)this.gravity;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= (double)0.98f;
        this.yd *= (double)0.98f;
        this.zd *= (double)0.98f;
        if (++this.age >= this.lifetime) {
            this.remove();
        }
    }

    public void render(VertexConsumer buffer, Camera camera, float partialTicks) {
        Quaternionf quaternionf = new Quaternionf((Quaternionfc)camera.rotation());
        this.getFacingCameraMode().setRotation(quaternionf, camera, partialTicks);
        if (this.roll != 0.0f) {
            quaternionf.rotateZ(Mth.lerp((float)partialTicks, (float)this.oRoll, (float)this.roll));
        }
        this.renderRotatedQuad(buffer, camera, quaternionf, partialTicks);
    }

    protected void renderRotatedQuad(VertexConsumer buffer, Quaternionf quaternion, float x, float y, float z, float partialTicks) {
        float f = this.getQuadSize(partialTicks);
        float f1 = this.getU0();
        float f2 = this.getU1();
        float f3 = this.getV0();
        float f4 = this.getV1();
        int i = this.getLightColor(partialTicks);
        this.renderVertex(buffer, quaternion, x, y, z, 1.0f, -1.0f, f, f2, f4, i);
        this.renderVertex(buffer, quaternion, x, y, z, 1.0f, 1.0f, f, f2, f3, i);
        this.renderVertex(buffer, quaternion, x, y, z, -1.0f, 1.0f, f, f1, f3, i);
        this.renderVertex(buffer, quaternion, x, y, z, -1.0f, -1.0f, f, f1, f4, i);
    }

    private void renderVertex(VertexConsumer buffer, Quaternionf quaternion, float x, float y, float z, float xOffset, float yOffset, float quadSize, float u, float v, int packedLight) {
        Vector3f vector3f = new Vector3f(xOffset, yOffset, 0.0f).rotate((Quaternionfc)quaternion).mul(quadSize, quadSize * this.stretchFactor, quadSize).add(x, y, z);
        buffer.addVertex(vector3f.x(), vector3f.y(), vector3f.z()).setUv(u, v).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(packedLight);
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ModDripParticle(level, x, y, z, this.spriteSet);
        }
    }
}

