/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.util;

import net.farkas.wildaside.block.entity.BlasterBlockEntity;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;

public class BlasterUtils {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canTraverse(Direction dir, BlockState nextBlockState, BlockState originBlockState, BlasterBlockEntity blockEntity) {
        Direction.Axis axis = dir.getAxis();
        Block nextBlock = nextBlockState.getBlock();
        if (axis == Direction.Axis.Y) {
            if (nextBlock instanceof SlabBlock) {
                return false;
            }
            if (!(nextBlock instanceof TrapDoorBlock ? (Boolean)nextBlockState.getValue((Property)TrapDoorBlock.OPEN) == false : nextBlock instanceof StairBlock)) return true;
            return false;
        }
        if (axis == Direction.Axis.X) {
            if (nextBlock instanceof StairBlock) {
                if (((Direction)nextBlockState.getValue((Property)StairBlock.FACING)).getAxis() != Direction.Axis.X) return true;
                return false;
            }
            if (nextBlock instanceof TrapDoorBlock) {
                Direction facing;
                if (!((Boolean)nextBlockState.getValue((Property)TrapDoorBlock.OPEN)).booleanValue() || (facing = (Direction)nextBlockState.getValue((Property)TrapDoorBlock.FACING)).getAxis() != Direction.Axis.X) return true;
                if (BlasterUtils.axisToDirection(axis, dir.getStepX()) == facing) {
                    return false;
                }
                blockEntity.shouldBreakNext = true;
                return true;
            } else {
                if (!(nextBlock instanceof DoorBlock)) return true;
                Boolean open = (Boolean)nextBlockState.getValue((Property)DoorBlock.OPEN);
                Direction facing = (Direction)nextBlockState.getValue((Property)DoorBlock.FACING);
                if (!open.booleanValue()) {
                    if (facing.getAxis() != Direction.Axis.X) return true;
                    if (dir == facing) {
                        return false;
                    }
                    blockEntity.shouldBreakNext = true;
                    return true;
                } else {
                    if (facing.getAxis() == Direction.Axis.X) return true;
                    if (BlasterUtils.doorDirectionCheck(dir.getAxis(), dir.getStepX(), facing).booleanValue()) {
                        if (nextBlockState.getValue((Property)DoorBlock.HINGE) == DoorHingeSide.LEFT) {
                            return false;
                        }
                        blockEntity.shouldBreakNext = true;
                        return true;
                    } else {
                        if (nextBlockState.getValue((Property)DoorBlock.HINGE) != DoorHingeSide.LEFT) return false;
                        blockEntity.shouldBreakNext = true;
                    }
                }
            }
            return true;
        } else {
            if (axis != Direction.Axis.Z) return true;
            if (nextBlock instanceof StairBlock) {
                if (((Direction)nextBlockState.getValue((Property)StairBlock.FACING)).getAxis() != Direction.Axis.Z) return true;
                return false;
            }
            if (nextBlock instanceof TrapDoorBlock) {
                Direction facing;
                if (!((Boolean)nextBlockState.getValue((Property)TrapDoorBlock.OPEN)).booleanValue() || (facing = (Direction)nextBlockState.getValue((Property)TrapDoorBlock.FACING)).getAxis() != Direction.Axis.Z) return true;
                if (dir == facing) {
                    return false;
                }
                blockEntity.shouldBreakNext = true;
                return true;
            } else {
                if (!(nextBlock instanceof DoorBlock)) return true;
                Boolean open = (Boolean)nextBlockState.getValue((Property)DoorBlock.OPEN);
                Direction facing = (Direction)nextBlockState.getValue((Property)DoorBlock.FACING);
                if (!open.booleanValue()) {
                    if (facing.getAxis() != Direction.Axis.Z) return true;
                    if (dir == facing) {
                        return false;
                    }
                    blockEntity.shouldBreakNext = true;
                    return true;
                } else {
                    if (facing.getAxis() == Direction.Axis.Z) return true;
                    if (BlasterUtils.doorDirectionCheck(axis, dir.getStepZ(), facing).booleanValue()) {
                        if (nextBlockState.getValue((Property)DoorBlock.HINGE) == DoorHingeSide.RIGHT) {
                            return false;
                        }
                        blockEntity.shouldBreakNext = true;
                        return true;
                    } else {
                        if (nextBlockState.getValue((Property)DoorBlock.HINGE) != DoorHingeSide.RIGHT) return false;
                        blockEntity.shouldBreakNext = true;
                    }
                }
            }
        }
        return true;
    }

    public static Direction axisToDirection(Direction.Axis axis, int offset) {
        if (axis.equals((Object)Direction.Axis.X)) {
            if (offset == 1) {
                return Direction.EAST;
            }
            return Direction.WEST;
        }
        if (axis.equals((Object)Direction.Axis.Y)) {
            if (offset == 1) {
                return Direction.UP;
            }
            return Direction.DOWN;
        }
        if (axis.equals((Object)Direction.Axis.Z)) {
            if (offset == 1) {
                return Direction.SOUTH;
            }
            return Direction.NORTH;
        }
        return Direction.UP;
    }

    public static Boolean doorDirectionCheck(Direction.Axis axis, int offset, Direction facing) {
        if (axis.equals((Object)Direction.Axis.X)) {
            return BlasterUtils.axisToDirection(Direction.Axis.Z, -offset) == facing;
        }
        if (axis.equals((Object)Direction.Axis.Z)) {
            return BlasterUtils.axisToDirection(Direction.Axis.X, -offset) == facing;
        }
        return false;
    }
}

