/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.worldgen.feature.custom;

import com.mojang.serialization.Codec;
import net.farkas.wildaside.block.custom.vibrion.VibrionGel;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class HangingStringFeature
extends Feature<SimpleBlockConfiguration> {
    private BlockStateProvider stringBlock;

    public HangingStringFeature(Codec<SimpleBlockConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<SimpleBlockConfiguration> context) {
        this.stringBlock = ((SimpleBlockConfiguration)context.config()).toPlace();
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        if (!this.areChunksLoaded((LevelAccessor)level, origin, 2)) {
            return false;
        }
        BlockPos wallPos = this.findWall((LevelAccessor)level, origin, 20, 10, random);
        if (wallPos == null) {
            return false;
        }
        this.placeSaggingLine((LevelAccessor)level, origin, wallPos, this.stringBlock.getState(random, context.origin()), (float)random.nextInt(1, 11) / 10.0f);
        return true;
    }

    private boolean areChunksLoaded(LevelAccessor level, BlockPos pos, int radius) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int chunkX = pos.getX() >> 4;
            int chunkZ = pos.getZ() >> 4;
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    if (serverLevel.hasChunk(chunkX + dx, chunkZ + dz)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private BlockPos findWall(LevelAccessor world, BlockPos origin, int maxHorizontal, int maxVertical, RandomSource random) {
        int dx = Mth.clamp((int)(random.nextInt(maxHorizontal * 2 + 1) - maxHorizontal), (int)-8, (int)8);
        int dz = Mth.clamp((int)(random.nextInt(maxHorizontal * 2 + 1) - maxHorizontal), (int)-8, (int)8);
        for (int y = origin.getY() - maxVertical; y < origin.getY() + maxVertical; ++y) {
            BlockPos pos = new BlockPos(origin.getX() + dx, y, origin.getZ() + dz);
            if (world.getBlockState(pos).isAir()) continue;
            return pos;
        }
        return null;
    }

    private void placeSaggingLine(LevelAccessor world, BlockPos start, BlockPos end, BlockState state, float sagFactor) {
        Vector3d startVec = new Vector3d((double)start.getX() + 0.5, (double)start.getY() + 0.5, (double)start.getZ() + 0.5);
        Vector3d endVec = new Vector3d((double)end.getX() + 0.5, (double)end.getY() + 0.5, (double)end.getZ() + 0.5);
        double length = startVec.distance((Vector3dc)endVec);
        int steps = (int)(length * 3.0);
        for (int i = 0; i <= steps; ++i) {
            double t = (double)i / (double)steps;
            double x = Mth.lerp((double)t, (double)startVec.x, (double)endVec.x);
            double z = Mth.lerp((double)t, (double)startVec.z, (double)endVec.z);
            double y = Mth.lerp((double)t, (double)startVec.y, (double)endVec.y);
            double sag = Math.sin(t * Math.PI) * length * (double)sagFactor;
            BlockPos pos = new BlockPos(Mth.floor((double)x), Mth.floor((double)(y -= sag)), Mth.floor((double)z));
            if (!world.isEmptyBlock(pos) && !world.getBlockState(pos).canBeReplaced()) continue;
            if (world.isWaterAt(pos)) {
                state = (BlockState)state.setValue((Property)VibrionGel.WATERLOGGED, (Comparable)Boolean.valueOf(true));
            }
            world.setBlock(pos, state, 3);
        }
    }
}

