/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.worldgen.feature.custom;

import com.mojang.serialization.Codec;
import net.farkas.wildaside.block.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;

public class HickoryBushFeature
extends Feature<SimpleBlockConfiguration> {
    public HickoryBushFeature(Codec<SimpleBlockConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<SimpleBlockConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (level.getBlockState(pos.offset(x, -1, z)).isSolid()) continue;
                return false;
            }
        }
        BlockState leaves = ((SimpleBlockConfiguration)context.config()).toPlace().getState(context.random(), pos);
        level.setBlock(pos, ((Block)ModBlocks.HICKORY_LOG.get()).defaultBlockState(), 3);
        RandomSource random = context.random();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos newPos;
                if (x != 0 && z != 0 && !(random.nextFloat() < 0.5f) || level.getBlockState(newPos = pos.offset(x, 0, z)).isSolid()) continue;
                level.setBlock(newPos, leaves, 3);
                level.scheduleTick(newPos, level.getBlockState(newPos).getBlock(), 0);
            }
        }
        BlockPos topPos = pos.above();
        if (!level.getBlockState(topPos).isSolid()) {
            level.setBlock(topPos, leaves, 3);
            level.scheduleTick(topPos, level.getBlockState(topPos).getBlock(), 0);
        }
        return true;
    }
}

