/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.worldgen.feature.custom;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import net.farkas.wildaside.block.custom.vibrion.NaturalSporeBlaster;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.ReplaceBlockFeature;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ReplaceBlockConfiguration;

public class NaturalSporeBlasterFeature
extends ReplaceBlockFeature {
    public NaturalSporeBlasterFeature(Codec<ReplaceBlockConfiguration> p_66651_) {
        super(p_66651_);
    }

    public boolean place(FeaturePlaceContext<ReplaceBlockConfiguration> context) {
        WorldGenLevel worldgenlevel = context.level();
        BlockPos blockpos = context.origin();
        ReplaceBlockConfiguration replaceblockconfiguration = (ReplaceBlockConfiguration)context.config();
        for (OreConfiguration.TargetBlockState oreconfiguration$targetblockstate : replaceblockconfiguration.targetStates) {
            if (!oreconfiguration$targetblockstate.target.test(worldgenlevel.getBlockState(blockpos), context.random())) continue;
            Direction.Axis[] axes = new Direction.Axis[]{Direction.Axis.X, Direction.Axis.Y, Direction.Axis.Z};
            ArrayList<Direction.Axis> freeAxes = new ArrayList<Direction.Axis>();
            for (Direction.Axis candidate : axes) {
                boolean isFree2;
                int x = candidate.equals((Object)Direction.Axis.X) ? 1 : 0;
                int y = candidate.equals((Object)Direction.Axis.Y) ? 1 : 0;
                int z = candidate.equals((Object)Direction.Axis.Z) ? 1 : 0;
                BlockPos pos1 = blockpos.offset(x, y, z);
                BlockPos pos2 = blockpos.offset(-x, -y, -z);
                boolean isFree1 = !worldgenlevel.getBlockState(pos1).isCollisionShapeFullBlock((BlockGetter)worldgenlevel, pos1);
                boolean bl = isFree2 = !worldgenlevel.getBlockState(pos2).isCollisionShapeFullBlock((BlockGetter)worldgenlevel, pos2);
                if (!isFree1 && !isFree2) continue;
                freeAxes.add(candidate);
            }
            if (freeAxes.isEmpty()) {
                return false;
            }
            Direction.Axis chosenAxis = (Direction.Axis)freeAxes.get(context.random().nextInt(freeAxes.size()));
            worldgenlevel.setBlock(blockpos, (BlockState)oreconfiguration$targetblockstate.state.setValue((Property)NaturalSporeBlaster.AXIS, (Comparable)chosenAxis), 3);
            worldgenlevel.scheduleTick(blockpos, worldgenlevel.getBlockState(blockpos).getBlock(), 10);
            break;
        }
        return true;
    }
}

