/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.block.entity;

import java.util.List;
import net.farkas.wildaside.block.entity.BlasterBlockEntity;
import net.farkas.wildaside.block.entity.ModBlockEntities;
import net.farkas.wildaside.particle.ModParticles;
import net.farkas.wildaside.util.BlasterUtils;
import net.farkas.wildaside.util.ContaminationHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class NaturalSporeBlasterBlockEntity
extends BlasterBlockEntity {
    private static final int MAX_TIMER = 40;
    private int changePowerTimer = 40;
    private int power1 = 0;
    private int power2 = 0;

    public NaturalSporeBlasterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.NATURAL_SPORE_BLASTER.get(), pos, state);
    }

    public void tickServer() {
        Direction.Axis axis;
        Level level = this.m_58904_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)level;
        RandomSource rand = world.m_213780_();
        if (++this.changePowerTimer >= 40) {
            this.changePowerTimer = 0;
            this.power1 = (double)rand.m_188501_() > 0.25 ? rand.m_216332_(0, 15) : 0;
            this.power2 = (double)rand.m_188501_() > 0.25 ? rand.m_216332_(0, 15) : 0;
        }
        int dx = (axis = (Direction.Axis)this.m_58900_().m_61143_((Property)RotatedPillarBlock.f_55923_)) == Direction.Axis.X ? 1 : 0;
        int dy = axis == Direction.Axis.Y ? 1 : 0;
        int dz = axis == Direction.Axis.Z ? 1 : 0;
        this.infectAlongLine(world, this.f_58858_, rand, this.power1, dx, dy, dz);
        this.infectAlongLine(world, this.f_58858_, rand, this.power2, -dx, -dy, -dz);
        world.m_186460_(this.f_58858_, this.m_58900_().m_60734_(), 2);
    }

    private void infectAlongLine(ServerLevel world, BlockPos origin, RandomSource random, int power, int x, int y, int z) {
        SimpleParticleType particle = (SimpleParticleType)ModParticles.VIBRION_PARTICLE.get();
        for (int i = 1; i <= power; ++i) {
            if (this.shouldBreakNext) {
                this.shouldBreakNext = false;
                break;
            }
            BlockPos pos = origin.m_7918_(x * i, y * i, z * i);
            BlockState next = world.m_8055_(pos);
            if (next.m_60838_((BlockGetter)world, pos) || !BlasterUtils.canTraverse(Direction.m_122378_((int)(x * i), (int)(y * i), (int)(z * i)), next, world.m_8055_(origin), this)) break;
            world.m_8767_((ParticleOptions)particle, (double)pos.m_123341_() + random.m_188500_(), (double)pos.m_123342_() + random.m_188500_(), (double)pos.m_123343_() + random.m_188500_(), 1, (double)x * 0.02, (double)y * 0.02, (double)z * 0.02, 0.0);
            List hits = world.m_6443_(LivingEntity.class, new AABB(pos), e -> !e.m_5833_());
            for (LivingEntity e2 : hits) {
                ContaminationHandler.addDose((Entity)e2, 50);
                world.m_8767_((ParticleOptions)particle, e2.m_20185_(), e2.m_20186_() + 0.5, e2.m_20189_(), 5, 0.2, 0.2, 0.2, 0.01);
            }
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.changePowerTimer = tag.m_128451_("changeTimer");
        this.power1 = tag.m_128451_("power1");
        this.power2 = tag.m_128451_("power2");
        this.shouldBreakNext = tag.m_128471_("shouldBreakNext");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("changeTimer", this.changePowerTimer);
        tag.m_128405_("power1", this.power1);
        tag.m_128405_("power2", this.power2);
        tag.m_128379_("shouldBreakNext", this.shouldBreakNext);
    }
}

