/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.block.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.StreamSupport;
import net.farkas.wildaside.block.custom.vibrion.PotionBlaster;
import net.farkas.wildaside.block.entity.BlasterBlockEntity;
import net.farkas.wildaside.block.entity.ModBlockEntities;
import net.farkas.wildaside.screen.potion_blaster.PotionBlasterMenu;
import net.farkas.wildaside.util.AdvancementHandler;
import net.farkas.wildaside.util.BlasterUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class PotionBlasterBlockEntity
extends BlasterBlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(10);
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    public static final int OUTPUT_1 = 9;
    public final ContainerData data;
    public int potionColour = 0;
    public int potionTicksLeft = 0;
    public int maxPotionTicks = 200;
    public int lastUsedSlot = -1;
    public ItemStack activePotion = ItemStack.f_41583_;
    public boolean shouldSelectNewPotion = true;

    public PotionBlasterBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.POTION_BLASTER.get(), pPos, pBlockState);
        this.data = new ContainerData(){

            public int m_6413_(int pIndex) {
                return switch (pIndex) {
                    case 0 -> PotionBlasterBlockEntity.this.potionTicksLeft;
                    case 1 -> PotionBlasterBlockEntity.this.maxPotionTicks;
                    case 2 -> PotionBlasterBlockEntity.this.potionColour;
                    default -> 0;
                };
            }

            public void m_8050_(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        PotionBlasterBlockEntity.this.potionTicksLeft = pValue;
                        break;
                    }
                    case 1: {
                        PotionBlasterBlockEntity.this.maxPotionTicks = pValue;
                        break;
                    }
                    case 2: {
                        PotionBlasterBlockEntity.this.potionColour = pValue;
                    }
                }
            }

            public int m_6499_() {
                return 3;
            }
        };
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.wildaside.potion_blaster");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new PotionBlasterMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public void shootPotionBeam(Direction direction, ServerLevel level, BlockPos pos) {
        if (this.activePotion.m_41619_()) {
            return;
        }
        List effects = PotionUtils.m_43547_((ItemStack)this.activePotion);
        if (effects.isEmpty()) {
            return;
        }
        int power = level.m_277086_(pos);
        this.potionColour = PotionUtils.m_43575_((ItemStack)this.activePotion);
        this.m_6596_();
        level.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        float r = (float)(this.potionColour >> 16 & 0xFF) / 255.0f;
        float g = (float)(this.potionColour >> 8 & 0xFF) / 255.0f;
        float b = (float)(this.potionColour & 0xFF) / 255.0f;
        DustParticleOptions particle = new DustParticleOptions(new Vector3f(r, g, b), 1.0f);
        RandomSource random = level.f_46441_;
        for (int i = 1; i <= power; ++i) {
            BlockState originBlock;
            if (this.shouldBreakNext) {
                this.shouldBreakNext = false;
                break;
            }
            BlockPos target = pos.m_5484_(direction, i);
            if (level.m_8055_(target).m_60838_((BlockGetter)level, target)) break;
            BlockState nextBlock = level.m_8055_(target);
            if (!BlasterUtils.canTraverse(direction, nextBlock, originBlock = level.m_8055_(this.m_58899_()), this)) {
                return;
            }
            for (int k = 0; k < 2; ++k) {
                double x = (double)target.m_123341_() + random.m_188500_();
                double y = (double)target.m_123342_() + random.m_188500_();
                double z = (double)target.m_123343_() + random.m_188500_();
                level.m_8767_((ParticleOptions)particle, x, y, z, 1, (double)direction.m_122429_(), (double)direction.m_122430_(), (double)direction.m_122431_(), 0.1);
            }
            List targets = level.m_45976_(LivingEntity.class, new AABB(target));
            for (LivingEntity entity : targets) {
                for (MobEffectInstance effect : effects) {
                    entity.m_7292_(new MobEffectInstance(effect.m_19544_(), effect.m_19557_() - (this.maxPotionTicks - this.potionTicksLeft), effect.m_19564_()));
                    level.m_8767_((ParticleOptions)particle, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 1, (double)direction.m_122429_(), (double)direction.m_122430_(), (double)direction.m_122431_(), 0.1);
                    if (!(entity instanceof ServerPlayer)) continue;
                    ServerPlayer player = (ServerPlayer)entity;
                    AdvancementHandler.givePlayerAdvancement((Entity)player, "brew_barrage");
                }
            }
        }
    }

    public void consumePotionBottle() {
        this.activePotion = ItemStack.f_41583_;
        this.potionTicksLeft = 0;
        this.maxPotionTicks = 200;
        this.lastUsedSlot = -1;
        this.shouldSelectNewPotion = true;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void selectNewPotion() {
        Level level;
        if (!this.activePotion.m_41619_() || this.potionTicksLeft > 0) {
            return;
        }
        ArrayList<Integer> validSlots = new ArrayList<Integer>();
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof PotionItem)) continue;
            validSlots.add(i);
        }
        if (validSlots.isEmpty()) {
            this.activePotion = ItemStack.f_41583_;
            this.lastUsedSlot = -1;
            this.shouldSelectNewPotion = true;
            return;
        }
        int slot = (Integer)validSlots.get(this.f_58857_.f_46441_.m_188503_(validSlots.size()));
        ItemStack extracted = this.itemHandler.extractItem(slot, 1, false);
        if (extracted.m_41619_()) {
            this.shouldSelectNewPotion = true;
            this.lastUsedSlot = -1;
            this.activePotion = ItemStack.f_41583_;
            return;
        }
        ItemStack remainder = this.itemHandler.insertItem(9, new ItemStack((ItemLike)Items.f_42590_), false);
        if (!remainder.m_41619_() && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7967_((Entity)new ItemEntity((Level)serverLevel, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.0, (double)this.f_58858_.m_123343_() + 0.5, remainder));
        }
        this.activePotion = extracted.m_41777_();
        this.lastUsedSlot = slot;
        this.shouldSelectNewPotion = false;
        List effectInstances = PotionUtils.m_43547_((ItemStack)this.activePotion);
        List effects = StreamSupport.stream(effectInstances.spliterator(), false).toList();
        this.potionTicksLeft = this.maxPotionTicks = effects.isEmpty() ? 200 : effects.stream().mapToInt(MobEffectInstance::m_19557_).max().orElse(200);
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128405_("ticks_left", this.potionTicksLeft);
        pTag.m_128405_("max_ticks", this.maxPotionTicks);
        pTag.m_128405_("colour", this.potionColour);
        pTag.m_128365_("potion", (Tag)this.activePotion.m_41739_(new CompoundTag()));
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.potionTicksLeft = pTag.m_128451_("ticks_left");
        this.maxPotionTicks = pTag.m_128451_("max_ticks");
        this.potionColour = pTag.m_128451_("colour");
        this.activePotion = pTag.m_128441_("potion") ? ItemStack.m_41712_((CompoundTag)pTag.m_128469_("potion")) : ItemStack.f_41583_;
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (level.m_5776_()) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PotionBlasterBlockEntity) {
            PotionBlasterBlockEntity be = (PotionBlasterBlockEntity)blockEntity;
            if (level.m_277086_(pos) > 0) {
                int poweredSides = 0;
                for (Direction dir : Direction.values()) {
                    if (level.m_277185_(pos.m_121945_(dir), dir) <= 0) continue;
                    ++poweredSides;
                }
                if (poweredSides >= 2) {
                    this.clearActivePotion();
                    return;
                }
                if ((this.potionTicksLeft <= 0 || this.activePotion.m_41619_()) && this.shouldSelectNewPotion) {
                    this.selectNewPotion();
                }
                if (!this.activePotion.m_41619_()) {
                    this.shootPotionBeam((Direction)state.m_61143_((Property)PotionBlaster.FACING), (ServerLevel)level, pos);
                    --this.potionTicksLeft;
                    if (this.potionTicksLeft <= 0) {
                        this.consumePotionBottle();
                    }
                }
            }
        }
    }

    public void clearActivePotion() {
        if (!this.activePotion.m_41619_()) {
            this.activePotion = ItemStack.f_41583_;
            this.potionTicksLeft = 0;
            this.lastUsedSlot = -1;
            this.shouldSelectNewPotion = true;
            this.m_6596_();
            if (this.f_58857_ != null) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }
}

