/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import net.farkas.wildaside.network.WindData;
import net.farkas.wildaside.network.WindSavedData;
import net.farkas.wildaside.util.ContaminationHandler;
import net.farkas.wildaside.util.WindManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class ModCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)Commands.m_82127_((String)"wildaside").requires(cs -> cs.m_6761_(2));
        root.then(Commands.m_82127_((String)"contamination").then(Commands.m_82129_((String)"action", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82967_((String[])new String[]{"add", "get", "set", "clear"}, (SuggestionsBuilder)builder)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> ModCommands.executeContamination((CommandContext<CommandSourceStack>)ctx, true)))).executes(ctx -> ModCommands.executeContamination((CommandContext<CommandSourceStack>)ctx, false)))));
        root.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"wind").then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"x", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.m_82129_((String)"y", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.m_82129_((String)"z", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.m_82129_((String)"strength", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(ctx -> {
            double x = DoubleArgumentType.getDouble((CommandContext)ctx, (String)"x");
            double y = DoubleArgumentType.getDouble((CommandContext)ctx, (String)"y");
            double z = DoubleArgumentType.getDouble((CommandContext)ctx, (String)"z");
            float s = FloatArgumentType.getFloat((CommandContext)ctx, (String)"strength");
            Vec3 vec = new Vec3(x, y, z);
            WindManager.setWind(vec, s);
            ServerLevel serverLevel = ((CommandSourceStack)ctx.getSource()).m_81372_();
            WindSavedData windSavedData = WindSavedData.get(serverLevel);
            windSavedData.setWeather(serverLevel.m_46471_(), serverLevel.m_46470_());
            windSavedData.setWind(vec, s);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Set wind to (" + x + ", " + y + ", " + z + ") strength=" + s)), true);
            return 1;
        }))))))).then(Commands.m_82127_((String)"random").executes(ctx -> {
            ServerLevel serverLevel = ((CommandSourceStack)ctx.getSource()).m_81372_();
            WindData windData = WindManager.calculateAndSetWind(serverLevel, true);
            Vec3 dir = windData.direction();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Set random wind to (" + dir.f_82479_ + ", " + dir.f_82480_ + ", " + dir.f_82481_ + ") strength=" + windData.strength())), true);
            return 1;
        }))).then(Commands.m_82127_((String)"get").executes(ctx -> {
            float strength = WindManager.getStrength();
            Vec3 dir = WindManager.getDirection();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Current wind: (" + dir.f_82479_ + ", " + dir.f_82480_ + ", " + dir.f_82481_ + ") strength=" + strength)), false);
            return 1;
        })));
        dispatcher.register(root);
    }

    private static int executeContamination(CommandContext<CommandSourceStack> ctx, boolean hasAmount) throws CommandSyntaxException {
        String action = StringArgumentType.getString(ctx, (String)"action");
        Collection targets = EntityArgument.m_91461_(ctx, (String)"targets");
        int amount = hasAmount ? IntegerArgumentType.getInteger(ctx, (String)"amount") : 0;
        int affected = 0;
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        block12: for (Entity entity : targets) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            switch (action.toLowerCase()) {
                case "add": {
                    ContaminationHandler.addDose((Entity)living, amount);
                    source.m_288197_(() -> Component.m_237113_((String)("Added " + amount + " of contamination to " + living.m_7755_().getString())), false);
                    ++affected;
                    continue block12;
                }
                case "get": {
                    int current = ContaminationHandler.getDose((Entity)living);
                    source.m_288197_(() -> Component.m_237113_((String)(living.m_7755_().getString() + " has " + current + " contamination")), false);
                    ++affected;
                    continue block12;
                }
                case "set": {
                    ContaminationHandler.setDose((Entity)living, amount);
                    source.m_288197_(() -> Component.m_237113_((String)("Set contamination of " + living.m_7755_().getString() + " to " + amount)), false);
                    ++affected;
                    continue block12;
                }
                case "clear": {
                    ContaminationHandler.setDose((Entity)living, 0);
                    source.m_288197_(() -> Component.m_237113_((String)("Cleared contamination of " + living.m_7755_().getString())), false);
                    ++affected;
                    continue block12;
                }
            }
            source.m_81352_((Component)Component.m_237113_((String)("Invalid action: " + action)));
            return 0;
        }
        if (affected > 0) {
            String entityString = affected > 1 ? "entities" : "entity";
            int finalAffected = affected;
            source.m_288197_(() -> Component.m_237113_((String)("Applied '" + action + "' to " + finalAffected + " " + entityString)), true);
        } else {
            source.m_81352_((Component)Component.m_237113_((String)"No valid living entities found."));
        }
        return affected;
    }
}

