/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.entity.ai.contaminated;

import java.util.EnumSet;
import java.util.List;
import net.farkas.wildaside.entity.custom.vibrion.ContaminatedCreeperEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ApproachWhenLookedAtGoal
extends Goal {
    private final ContaminatedCreeperEntity creeper;
    private final double detectDistance;
    private final double speed;
    private final Level level;

    public ApproachWhenLookedAtGoal(ContaminatedCreeperEntity creeper, double speed, double detectDistance, double triggerDistance) {
        this.creeper = creeper;
        this.detectDistance = detectDistance;
        this.speed = speed;
        this.level = creeper.m_9236_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.creeper.getState() == 3) {
            return false;
        }
        List players = this.level.m_45976_(Player.class, this.creeper.m_20191_().m_82400_(this.detectDistance / 2.0));
        for (Player player : players) {
            if (!player.m_6097_() || !player.m_142582_((Entity)this.creeper) || !this.isLookingAt(player, this.creeper)) continue;
            this.creeper.m_6710_((LivingEntity)player);
            return true;
        }
        return false;
    }

    public void m_8037_() {
        if (this.creeper.m_5448_() == null) {
            return;
        }
        Player target = (Player)this.creeper.m_5448_();
        this.creeper.m_21563_().m_148051_((Entity)this.creeper.m_5448_());
        this.creeper.m_21573_().m_5624_((Entity)target, this.speed);
    }

    public void m_8056_() {
        super.m_8056_();
        this.creeper.setState(1);
    }

    public boolean m_183429_() {
        return true;
    }

    private boolean isLookingAt(Player player, ContaminatedCreeperEntity creeper) {
        double dz;
        double dy;
        double dx = creeper.m_20185_() - player.m_20185_();
        double dist = Math.sqrt(dx * dx + (dy = creeper.m_20188_() - player.m_20188_()) * dy + (dz = creeper.m_20189_() - player.m_20189_()) * dz);
        if (dist > this.detectDistance) {
            return false;
        }
        Vec3 look = player.m_20154_().m_82541_();
        double dot = (dx /= dist) * look.f_82479_ + (dy /= dist) * look.f_82480_ + (dz /= dist) * look.f_82481_;
        return dot > 0.99;
    }
}

