/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.entity.ai.mucellith;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.farkas.wildaside.entity.custom.vibrion.MucellithEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;

public class MucellithAttackGoal
extends Goal {
    private static final int WINDUP_DURATION = 7;
    private final Mob mob;
    private final MucellithEntity entity;
    @Nullable
    private LivingEntity target;
    private int attackTime = 60;
    private final int attackTimeMax;
    private final float attackRadius;
    private int windupTicks;

    public MucellithAttackGoal(MucellithEntity entity, int pAttackInterval, float pAttackRadius) {
        this.entity = entity;
        this.mob = entity;
        this.attackTimeMax = pAttackInterval;
        this.attackRadius = pAttackRadius;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.entity.isDefending()) {
            return false;
        }
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity != null && livingentity.m_6084_() && !(livingentity instanceof MucellithEntity)) {
            this.target = livingentity;
            return true;
        }
        return false;
    }

    public void m_8041_() {
        this.entity.setAttacking(false);
        this.attackTime = this.attackTimeMax;
        this.target = null;
    }

    public void m_8056_() {
        this.attackTime = this.attackTimeMax;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        Player player;
        LivingEntity livingEntity = this.target;
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_20147_()) {
            this.target = null;
        }
        if (this.target == null) {
            this.m_8041_();
            return;
        }
        this.shoot();
    }

    public void shoot() {
        --this.attackTime;
        this.mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        if (this.attackTime <= 0) {
            if (!this.mob.m_21574_().m_148306_((Entity)this.target)) {
                return;
            }
            this.entity.setAttacking(true);
            this.entity.attackAnimation.m_216977_(this.entity.f_19797_);
            this.entity.attackAnimationTimeout = this.entity.attackAnimationMax;
            this.attackTime = this.attackTimeMax;
            this.windupTicks = 7;
        }
        if (this.windupTicks > 0) {
            --this.windupTicks;
            if (this.windupTicks == 0) {
                float dist = (float)Math.sqrt(this.mob.m_20280_((Entity)this.target)) / this.attackRadius;
                float power = Mth.m_14036_((float)dist, (float)0.1f, (float)1.0f);
                this.entity.m_6504_(this.target, power);
            }
        }
        if (this.entity.isAttacking() && --this.entity.attackAnimationTimeout <= 0) {
            this.entity.attackAnimation.m_216973_();
            this.entity.setAttacking(false);
        }
    }
}

