/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class AnimatedModelTextureLayer<T extends LivingEntity, M extends HierarchicalModel<T>>
extends RenderLayer<T, M> {
    public ResourceLocation frame_0;
    public ResourceLocation frame_1;
    public int frameTime;
    public int totalFrames;
    public int[] sequence;

    public AnimatedModelTextureLayer(RenderLayerParent<T, HierarchicalModel<T>> renderer, ResourceLocation frame_0, ResourceLocation frame_1, int frameTime, int totalFrames, int[] sequence) {
        super(renderer);
        this.frame_0 = frame_0;
        this.frame_1 = frame_1;
        this.frameTime = frameTime;
        this.totalFrames = totalFrames;
        this.sequence = sequence;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        int totalTicks = (int)((float)((LivingEntity)entity).f_19797_ + partialTicks);
        int frameIndex = totalTicks / this.frameTime % this.totalFrames;
        int nextFrameIndex = (frameIndex + 1) % this.totalFrames;
        int currentFrame = this.sequence[frameIndex];
        int nextFrame = this.sequence[nextFrameIndex];
        float interp = ((float)(totalTicks % this.frameTime) + partialTicks) / (float)this.frameTime;
        ResourceLocation texA = currentFrame == 0 ? this.frame_0 : this.frame_1;
        ResourceLocation texB = nextFrame == 0 ? this.frame_0 : this.frame_1;
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)texA));
        float alphaA = 1.0f - interp;
        ((HierarchicalModel)this.m_117386_()).m_7695_(poseStack, buffer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alphaA);
        if (texB != texA) {
            VertexConsumer bufferB = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)texB));
            float alphaB = interp;
            ((HierarchicalModel)this.m_117386_()).m_7695_(poseStack, bufferB, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alphaB);
        }
    }
}

