/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.entity.custom.vibrion;

import net.farkas.wildaside.effect.ModMobEffects;
import net.farkas.wildaside.entity.ai.mucellith.MucellithAttackGoal;
import net.farkas.wildaside.entity.ai.mucellith.MucellithLookAtPlayerGoal;
import net.farkas.wildaside.entity.ai.mucellith.MucellithRandomLookAroundGoal;
import net.farkas.wildaside.entity.custom.vibrion.SporeBombEntity;
import net.farkas.wildaside.sound.ModSounds;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class MucellithEntity
extends PathfinderMob
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(MucellithEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DEFENDING = SynchedEntityData.m_135353_(MucellithEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_DEFENDED = SynchedEntityData.m_135353_(MucellithEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int soundCooldown = 0;
    private final int soundCooldownMax = 20;
    public final int attackAnimationMax = 60;
    public int attackAnimationTimeout = 0;
    public final AnimationState idleAnimation = new AnimationState();
    public final AnimationState attackAnimation = new AnimationState();
    public final AnimationState defenseAnimation = new AnimationState();
    public final AnimationState defenseAnimationReverse = new AnimationState();

    public MucellithEntity(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new MucellithAttackGoal(this, 60, 8.0f));
        this.f_21345_.m_25352_(2, (Goal)new MucellithLookAtPlayerGoal(this, Player.class, 64.0f));
        this.f_21345_.m_25352_(4, (Goal)new MucellithRandomLookAroundGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, entity -> entity.m_21023_((MobEffect)ModMobEffects.CONTAMINATION.get()) && !(entity instanceof MucellithEntity)));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, entity -> entity.m_21023_((MobEffect)ModMobEffects.CONTAMINATION.get()) && !(entity instanceof MucellithEntity)));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return PathfinderMob.m_21183_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22288_, 0.0).m_22268_(Attributes.f_22280_, 0.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.belowHealthThreshold(0.25f) && !this.hasDefended()) {
            this.setDefending(true);
            this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, -1, 6, false, true));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, -1, 1, false, true));
        }
        if (this.isDefending()) {
            if (this.soundCooldown <= 0) {
                this.m_5496_(SoundEvents.f_215762_, 1.0f, 1.5f);
                this.soundCooldown = 20;
            } else {
                --this.soundCooldown;
            }
            if (!this.belowHealthThreshold(0.5f)) {
                this.m_5496_(SoundEvents.f_215777_, 1.0f, 1.5f);
                this.setHasDefended(true);
                this.setDefending(false);
            }
        } else {
            this.m_21195_(MobEffects.f_19606_);
            this.m_21195_(MobEffects.f_19605_);
        }
    }

    private void setupAnimationStates() {
        if (this.isDefending()) {
            if (!this.defenseAnimation.m_216984_()) {
                this.defenseAnimation.m_216977_(this.f_19797_);
            }
        } else {
            this.defenseAnimation.m_216973_();
            if (this.hasDefended()) {
                if (!this.defenseAnimationReverse.m_216984_()) {
                    this.defenseAnimationReverse.m_216977_(this.f_19797_);
                }
            } else {
                this.defenseAnimationReverse.m_216973_();
            }
            if (!this.isAttacking()) {
                if (!this.idleAnimation.m_216984_()) {
                    this.idleAnimation.m_216977_(this.f_19797_);
                }
            } else {
                this.idleAnimation.m_216973_();
            }
        }
        if (this.isAttacking()) {
            if (!this.attackAnimation.m_216984_()) {
                this.attackAnimation.m_216977_(this.f_19797_);
            }
        } else {
            this.attackAnimation.m_216973_();
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(DEFENDING, (Object)false);
        this.f_19804_.m_135372_(HAS_DEFENDED, (Object)false);
    }

    public void m_6504_(LivingEntity pTarget, float pVelocity) {
        this.attackAnimation.m_216977_(0);
        SporeBombEntity sporeBomb = new SporeBombEntity(this.m_9236_(), (LivingEntity)this, this.f_19796_.m_188501_());
        double d0 = pTarget.m_20188_() - (double)1.1f;
        double d1 = pTarget.m_20185_() - this.m_20185_();
        double d2 = d0 - sporeBomb.m_20186_() - 0.5;
        double d3 = pTarget.m_20189_() - this.m_20189_();
        double d4 = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
        sporeBomb.m_6686_(d1, d2 + d4, d3, 1.6f, 2.0f);
        this.m_5496_(SoundEvents.f_12473_, 1.0f, 0.2f);
        this.m_9236_().m_7967_((Entity)sporeBomb);
    }

    public void m_7334_(Entity pEntity) {
    }

    public void m_5997_(double pX, double pY, double pZ) {
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public boolean m_6128_() {
        return true;
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    public void setDefending(boolean defending) {
        this.f_19804_.m_135381_(DEFENDING, (Object)defending);
    }

    public boolean isDefending() {
        return (Boolean)this.f_19804_.m_135370_(DEFENDING);
    }

    public void setHasDefended(boolean hasDefended) {
        this.f_19804_.m_135381_(HAS_DEFENDED, (Object)hasDefended);
    }

    public boolean hasDefended() {
        return (Boolean)this.f_19804_.m_135370_(HAS_DEFENDED);
    }

    public boolean belowHealthThreshold(float threshold) {
        return this.m_21223_() / this.m_21233_() <= threshold;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.MUCELLITH_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.MUCELLITH_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.MUCELLITH_DEATH.get();
    }
}

