/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.item.custom;

import net.farkas.wildaside.block.ModBlocks;
import net.farkas.wildaside.block.custom.FallenHickoryLeavesBlock;
import net.farkas.wildaside.item.FuelItem;
import net.farkas.wildaside.util.HickoryColour;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class HickoryLeafItem
extends FuelItem {
    private final HickoryColour colour;

    public HickoryLeafItem(Item.Properties pProperties, int burnTime, HickoryColour colour) {
        super(pProperties, burnTime);
        this.colour = colour;
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        Level level = pContext.m_43725_();
        if (level.m_5776_() || pContext.m_43724_() == InteractionHand.OFF_HAND) {
            return InteractionResult.PASS;
        }
        BlockPos pos = pContext.m_8083_();
        Player player = pContext.m_43723_();
        InteractionHand hand = pContext.m_43724_();
        BlockState blockState = level.m_8055_(pos);
        if (blockState.m_60734_() instanceof FallenHickoryLeavesBlock) {
            return this.addLeaf(level, pos, player, hand);
        }
        if (blockState.m_60783_((BlockGetter)level, pos, Direction.UP)) {
            return this.placeLeaf(level, pos, player, hand);
        }
        return InteractionResult.PASS;
    }

    private InteractionResult placeLeaf(Level level, BlockPos pos, Player player, InteractionHand hand) {
        BlockPos abovePos = pos.m_7494_();
        if (!level.m_46859_(abovePos)) {
            if (level.m_8055_(abovePos).m_60734_() instanceof FallenHickoryLeavesBlock) {
                return this.addLeaf(level, abovePos, player, hand);
            }
            return InteractionResult.PASS;
        }
        BlockState newState = (BlockState)((BlockState)((Block)ModBlocks.FALLEN_HICKORY_LEAVES.get()).m_49966_().m_61124_(FallenHickoryLeavesBlock.COLOUR, (Comparable)((Object)this.colour))).m_61124_((Property)FallenHickoryLeavesBlock.FACING, (Comparable)player.m_6350_().m_122424_());
        level.m_7731_(abovePos, newState, 3);
        this.onSuccessfulPlacement(level, abovePos, player, hand);
        return InteractionResult.SUCCESS;
    }

    private InteractionResult addLeaf(Level level, BlockPos pos, Player player, InteractionHand hand) {
        BlockState leaves = level.m_8055_(pos);
        if (this.colour != leaves.m_61143_(FallenHickoryLeavesBlock.COLOUR)) {
            return InteractionResult.PASS;
        }
        int count = (Integer)leaves.m_61143_((Property)FallenHickoryLeavesBlock.COUNT);
        if (count >= 3) {
            return InteractionResult.PASS;
        }
        BlockState newState = (BlockState)leaves.m_61124_((Property)FallenHickoryLeavesBlock.COUNT, (Comparable)Integer.valueOf(count + 1));
        level.m_7731_(pos, newState, 3);
        this.onSuccessfulPlacement(level, pos, player, hand);
        return InteractionResult.SUCCESS;
    }

    private void onSuccessfulPlacement(Level level, BlockPos pos, Player player, InteractionHand hand) {
        ItemStack item = player.m_21120_(hand);
        level.m_5594_(null, pos, SoundEvents.f_144081_, SoundSource.BLOCKS, 1.0f, 1.1f);
        if (!player.m_20147_()) {
            item.m_41774_(1);
        }
    }

    public HickoryColour getColour() {
        return this.colour;
    }
}

