/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.network;

import net.farkas.wildaside.network.WindData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;

public class WindSavedData
extends SavedData {
    private boolean lastRaining = false;
    private boolean lastThundering = false;
    private double windX = 0.0;
    private double windY = 0.0;
    private double windZ = 0.0;
    private float windStrength = 0.0f;

    public WindSavedData(CompoundTag tag) {
        this.lastRaining = tag.m_128471_("lastRaining");
        this.lastThundering = tag.m_128471_("lastThundering");
        this.windX = tag.m_128459_("windX");
        this.windY = tag.m_128459_("windY");
        this.windZ = tag.m_128459_("windZ");
        this.windStrength = tag.m_128457_("windStrength");
    }

    public WindSavedData() {
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag.m_128379_("lastRaining", this.lastRaining);
        tag.m_128379_("lastThundering", this.lastThundering);
        tag.m_128347_("windX", this.windX);
        tag.m_128347_("windY", this.windY);
        tag.m_128347_("windZ", this.windZ);
        tag.m_128350_("windStrength", this.windStrength);
        return tag;
    }

    public boolean wasRaining() {
        return this.lastRaining;
    }

    public boolean wasThundering() {
        return this.lastThundering;
    }

    public void setWeather(boolean raining, boolean thundering) {
        this.lastRaining = raining;
        this.lastThundering = thundering;
        this.m_77762_();
    }

    public void setWind(Vec3 direction, float strength) {
        this.windX = direction.f_82479_;
        this.windY = direction.f_82480_;
        this.windZ = direction.f_82481_;
        this.windStrength = strength;
        this.m_77762_();
    }

    public Vec3 getWindDirection() {
        return new Vec3(this.windX, this.windY, this.windZ);
    }

    public float getWindStrength() {
        return this.windStrength;
    }

    public WindData getWindData() {
        return new WindData(this.getWindDirection(), this.getWindStrength());
    }

    public static WindSavedData get(ServerLevel level) {
        return (WindSavedData)level.m_8895_().m_164861_(WindSavedData::new, WindSavedData::new, "wildaside_weather");
    }
}

