/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.particle.custom;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ModDripParticle
extends TextureSheetParticle {
    private final int hangTime = 60;
    private final int stretchTime = 30;
    private float stretchFactor = 0.0f;

    protected ModDripParticle(ClientLevel level, double x, double y, double z, SpriteSet spriteSet) {
        super(level, x, y, z);
        this.m_107250_(0.01f, 0.01f);
        this.f_107225_ = 150 + this.f_107223_.m_188503_(20);
        this.f_107226_ = 0.0f;
        this.m_108335_(spriteSet);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_ < 60) {
            this.f_107216_ = 0.0;
            this.stretchFactor = 1.0f;
        } else if (this.f_107224_ < 90) {
            this.f_107226_ = 0.001f;
            float progress = (float)(this.f_107224_ - 60) / 30.0f;
            this.f_107216_ = 0.0;
            this.stretchFactor = 1.0f + 1.5f * progress;
        } else {
            this.f_107226_ = 0.05f;
        }
        this.f_107216_ -= (double)this.f_107226_;
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        this.f_107215_ *= (double)0.98f;
        this.f_107216_ *= (double)0.98f;
        this.f_107217_ *= (double)0.98f;
        if (++this.f_107224_ >= this.f_107225_) {
            this.m_107274_();
        }
    }

    public void m_5744_(VertexConsumer buffer, Camera camera, float partialTicks) {
        float originalQuadSize = this.f_107663_;
        float stretchedY = originalQuadSize * this.stretchFactor;
        Vec3 camPos = camera.m_90583_();
        float px = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - camPos.m_7096_());
        float py = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - camPos.m_7098_());
        float pz = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - camPos.m_7094_());
        Quaternionf rotation = new Quaternionf((Quaternionfc)camera.m_253121_());
        Vector3f[] quad = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        for (int i = 0; i < 4; ++i) {
            Vector3f vec = quad[i];
            vec.rotate((Quaternionfc)rotation);
            vec.mul(originalQuadSize, stretchedY, originalQuadSize);
            vec.add(px, py, pz);
        }
        float u0 = this.m_5970_();
        float u1 = this.m_5952_();
        float v0 = this.m_5951_();
        float v1 = this.m_5950_();
        int light = this.m_6355_(partialTicks);
        buffer.m_5483_((double)quad[0].x(), (double)quad[0].y(), (double)quad[0].z()).m_7421_(u1, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)quad[1].x(), (double)quad[1].y(), (double)quad[1].z()).m_7421_(u1, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)quad[2].x(), (double)quad[2].y(), (double)quad[2].z()).m_7421_(u0, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)quad[3].x(), (double)quad[3].y(), (double)quad[3].z()).m_7421_(u0, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ModDripParticle(level, x, y, z, this.spriteSet);
        }
    }
}

