/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.util;

import net.farkas.wildaside.capability.contamination.ContaminationCapability;
import net.farkas.wildaside.capability.contamination.IContamination;
import net.farkas.wildaside.effect.ModMobEffects;
import net.farkas.wildaside.entity.custom.vibrion.MucellithEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ContaminationHandler {
    private static final int MAX_AMPLIFIER = 5;

    public static void addDose(Entity entity, int dose) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        livingEntity.getCapability(ContaminationCapability.INSTANCE).ifPresent(data -> {
            data.addDose(dose);
            ContaminationHandler.applyContamination(livingEntity, data.getDose());
        });
    }

    public static void setDose(Entity entity, int dose) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        livingEntity.getCapability(ContaminationCapability.INSTANCE).ifPresent(data -> {
            data.setDose(dose);
            ContaminationHandler.applyContamination(livingEntity, data.getDose());
        });
    }

    public static int getDose(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return 0;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        return livingEntity.getCapability(ContaminationCapability.INSTANCE).map(IContamination::getDose).orElse(0);
    }

    public static void applyContamination(LivingEntity entity, int dose) {
        if (dose == 0 || entity instanceof MucellithEntity) {
            return;
        }
        MobEffect immunity = (MobEffect)ModMobEffects.IMMUNITY.get();
        MobEffect contamination = (MobEffect)ModMobEffects.CONTAMINATION.get();
        int amplifier = Mth.m_14045_((int)(dose / 1000), (int)0, (int)5);
        int contaminationDuration = ContaminationHandler.calculateContaminationDuration(amplifier);
        MobEffectInstance existing = entity.m_21124_(contamination);
        if (existing == null) {
            int immunityAmp;
            if (entity.m_21023_(immunity) && (immunityAmp = entity.m_21124_(immunity).m_19564_()) >= amplifier) {
                return;
            }
            entity.m_7292_(new MobEffectInstance(contamination, contaminationDuration, amplifier));
        } else {
            int immunityAmp;
            int existingAmp = existing.m_19564_();
            int existingDuration = existing.m_19557_();
            amplifier = Mth.m_14045_((int)(dose / 1000), (int)existingAmp, (int)5);
            contaminationDuration = ContaminationHandler.calculateContaminationDuration(amplifier);
            if (entity.m_21023_(immunity) && (immunityAmp = entity.m_21124_(immunity).m_19564_()) >= amplifier) {
                return;
            }
            if (amplifier > existingAmp || existingDuration < ContaminationHandler.calculateContaminationDuration(amplifier)) {
                entity.m_7292_(new MobEffectInstance(contamination, contaminationDuration, amplifier));
            }
        }
        if (amplifier >= 4) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, (amplifier + 1) * 2 * 20, amplifier - 3, false, true));
            if (amplifier >= 5) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_216964_, (amplifier + 1) * 3 * 20, amplifier - 4, false, true));
            }
        }
    }

    public static int calculateContaminationDuration(int amplifier) {
        return (amplifier + 1) * 10 * 20;
    }
}

