/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.worldgen.biome;

import net.farkas.wildaside.entity.ModEntities;
import net.farkas.wildaside.particle.ModParticles;
import net.farkas.wildaside.sound.ModSounds;
import net.farkas.wildaside.worldgen.ModPlacedFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;

public class ModBiomes {
    public static final ResourceKey<Biome> HICKORY_FOREST = ModBiomes.register("hickory_forest");
    public static final ResourceKey<Biome> GLOWING_HICKORY_FOREST = ModBiomes.register("glowing_hickory_forest");
    public static final ResourceKey<Biome> VIBRION_HIVE = ModBiomes.register("vibrion_hive");

    public static void bootstrap(BootstapContext<Biome> context) {
        context.m_255272_(HICKORY_FOREST, (Object)ModBiomes.hickoryForest(context));
        context.m_255272_(GLOWING_HICKORY_FOREST, (Object)ModBiomes.glowingHickoryForest(context));
        context.m_255272_(VIBRION_HIVE, (Object)ModBiomes.vibrionHive(context));
    }

    public static void globalOverworldGeneration(BiomeGenerationSettings.Builder builder) {
        BiomeDefaultFeatures.m_194720_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126810_((BiomeGenerationSettings.Builder)builder);
    }

    public static Biome hickoryForest(BootstapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 2, 3, 4));
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.m_255420_(Registries.f_256988_), context.m_255420_(Registries.f_257003_));
        ModBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126708_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126696_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.FLUID_SPRINGS, MiscOverworldPlacements.f_195276_);
        biomeBuilder.m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, ModPlacedFeatures.PODZOL_VEIN);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.HICKORY_TREE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.HICKORY_SAPLING);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.HICKORY_BUSH);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.FALLEN_HICKORY_TREE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.SPOTTED_WINTERGREEN);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.PINKSTER_FLOWER);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.EXTRA_TALL_GRASS);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.EXTRA_FERNS);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.EXTRA_TALL_FERNS);
        return new Biome.BiomeBuilder().m_264558_(true).m_47611_(0.8f).m_47609_(0.7f).m_47601_(biomeBuilder.m_255380_()).m_47605_(spawnBuilder.m_48381_()).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(4159204).m_48040_(7842047).m_48043_(3776026).m_48045_(5420593).m_48019_(12245759).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(null).m_48018_()).m_47592_();
    }

    public static Biome glowingHickoryForest(BootstapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 2, 3, 4));
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.m_255420_(Registries.f_256988_), context.m_255420_(Registries.f_257003_));
        ModBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126708_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126696_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.FLUID_SPRINGS, MiscOverworldPlacements.f_195276_);
        biomeBuilder.m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, ModPlacedFeatures.PODZOL_VEIN);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.RED_GLOWING_HICKORY_TREE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.BROWN_GLOWING_HICKORY_TREE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.YELLOW_GLOWING_HICKORY_TREE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.GREEN_GLOWING_HICKORY_TREE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.RED_GLOWING_HICKORY_SAPLING);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.BROWN_GLOWING_HICKORY_SAPLING);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.YELLOW_GLOWING_HICKORY_SAPLING);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.GREEN_GLOWING_HICKORY_SAPLING);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.RED_GLOWING_HICKORY_BUSH);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.BROWN_GLOWING_HICKORY_BUSH);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.YELLOW_GLOWING_HICKORY_BUSH);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.GREEN_GLOWING_HICKORY_BUSH);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.FALLEN_HICKORY_TREE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.SPOTTED_WINTERGREEN);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.PINKSTER_FLOWER);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.EXTRA_TALL_GRASS);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.EXTRA_FERNS);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.EXTRA_TALL_FERNS);
        return new Biome.BiomeBuilder().m_264558_(true).m_47611_(0.8f).m_47609_(0.7f).m_47601_(biomeBuilder.m_255380_()).m_47605_(spawnBuilder.m_48381_()).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(4159204).m_48040_(7842047).m_48043_(3776026).m_48045_(5420593).m_48019_(12245759).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(null).m_48018_()).m_47592_();
    }

    public static Biome vibrionHive(BootstapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.m_255420_(Registries.f_256988_), context.m_255420_(Registries.f_257003_));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.MUCELLITH.get(), 67, 2, 4));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        ModBiomes.globalOverworldGeneration(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.OVERGROWN_ENTORIUM_ORE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.NATURAL_SPORE_BLASTER);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.COMPRESSED_SUBSTILIUM_SOIL);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.SUBSTILIUM_COAL_ORE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.SUBSTILIUM_COPPER_ORE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.SUBSTILIUM_COPPER_ORE_LARGE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.SUBSTILIUM_LAPIS_ORE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.SUBSTILIUM_LAPIS_ORE_BURIED);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.SUBSTILIUM_IRON_ORE_SMALL);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.SUBSTILIUM_IRON_ORE_MIDDLE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.SUBSTILIUM_GOLD_ORE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.SUBSTILIUM_GOLD_ORE_LOWER);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.SUBSTILIUM_REDSTONE_ORE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.SUBSTILIUM_REDSTONE_ORE_LOWER);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.SUBSTILIUM_DIAMOND_ORE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.SUBSTILIUM_DIAMOND_ORE_BURIED);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.SUBSTILIUM_DIAMOND_ORE_LARGE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.SUBSTILIUM_EMERALD_ORE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, ModPlacedFeatures.VIBRION_GROWTH);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, ModPlacedFeatures.SUBSTILIUM_SPROUTS);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, ModPlacedFeatures.LARGE_SUBSTILIUM_MUSHROOM);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, ModPlacedFeatures.VIBRION_SPOREHOLDER);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, ModPlacedFeatures.HANGING_VIBRION_VINES);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, ModPlacedFeatures.HANGING_VIBRION_GEL);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, ModPlacedFeatures.HANGING_LIT_VIBRION_GEL);
        return new Biome.BiomeBuilder().m_264558_(false).m_47611_(0.4f).m_47609_(0.8f).m_47601_(biomeBuilder.m_255380_()).m_47605_(spawnBuilder.m_48381_()).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(15714931).m_48037_(15714931).m_48040_(11192803).m_48045_(15714931).m_48043_(15714931).m_48019_(11192803).m_48027_(AmbientMoodSettings.f_47387_).m_48029_(new AmbientParticleSettings((ParticleOptions)ModParticles.STILL_SUBSTILIUM_PARTICLE.get(), 0.05f)).m_48021_(new Music(Holder.m_205709_((Object)((SoundEvent)ModSounds.VIBRION_HIVE_MUSIC.get())), 6000, 12000, false)).m_48018_()).m_47592_();
    }

    public static ResourceKey<Biome> register(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("wildaside", name));
    }
}

