/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.worldgen.feature.custom;

import com.mojang.serialization.Codec;
import net.farkas.wildaside.block.custom.vibrion.VibrionGel;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class HangingStringFeature
extends Feature<SimpleBlockConfiguration> {
    private BlockStateProvider stringBlock;

    public HangingStringFeature(Codec<SimpleBlockConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<SimpleBlockConfiguration> context) {
        this.stringBlock = ((SimpleBlockConfiguration)context.m_159778_()).f_68069_();
        WorldGenLevel level = context.m_159774_();
        BlockPos origin = context.m_159777_();
        RandomSource random = context.m_225041_();
        if (!this.areChunksLoaded((LevelAccessor)level, origin, 2)) {
            return false;
        }
        BlockPos wallPos = this.findWall((LevelAccessor)level, origin, 20, 10, random);
        if (wallPos == null) {
            return false;
        }
        this.placeSaggingLine((LevelAccessor)level, origin, wallPos, this.stringBlock.m_213972_(random, context.m_159777_()), (float)random.m_216339_(1, 11) / 10.0f);
        return true;
    }

    private boolean areChunksLoaded(LevelAccessor level, BlockPos pos, int radius) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int chunkX = pos.m_123341_() >> 4;
            int chunkZ = pos.m_123343_() >> 4;
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    if (serverLevel.m_7232_(chunkX + dx, chunkZ + dz)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private BlockPos findWall(LevelAccessor world, BlockPos origin, int maxHorizontal, int maxVertical, RandomSource random) {
        int dx = Mth.m_14045_((int)(random.m_188503_(maxHorizontal * 2 + 1) - maxHorizontal), (int)-8, (int)8);
        int dz = Mth.m_14045_((int)(random.m_188503_(maxHorizontal * 2 + 1) - maxHorizontal), (int)-8, (int)8);
        for (int y = origin.m_123342_() - maxVertical; y < origin.m_123342_() + maxVertical; ++y) {
            BlockPos pos = new BlockPos(origin.m_123341_() + dx, y, origin.m_123343_() + dz);
            if (world.m_8055_(pos).m_60795_()) continue;
            return pos;
        }
        return null;
    }

    private void placeSaggingLine(LevelAccessor world, BlockPos start, BlockPos end, BlockState state, float sagFactor) {
        Vector3d startVec = new Vector3d((double)start.m_123341_() + 0.5, (double)start.m_123342_() + 0.5, (double)start.m_123343_() + 0.5);
        Vector3d endVec = new Vector3d((double)end.m_123341_() + 0.5, (double)end.m_123342_() + 0.5, (double)end.m_123343_() + 0.5);
        double length = startVec.distance((Vector3dc)endVec);
        int steps = (int)(length * 3.0);
        for (int i = 0; i <= steps; ++i) {
            double t = (double)i / (double)steps;
            double x = Mth.m_14139_((double)t, (double)startVec.x, (double)endVec.x);
            double z = Mth.m_14139_((double)t, (double)startVec.z, (double)endVec.z);
            double y = Mth.m_14139_((double)t, (double)startVec.y, (double)endVec.y);
            double sag = Math.sin(t * Math.PI) * length * (double)sagFactor;
            BlockPos pos = new BlockPos(Mth.m_14107_((double)x), Mth.m_14107_((double)(y -= sag)), Mth.m_14107_((double)z));
            if (!world.m_46859_(pos) && !world.m_8055_(pos).m_247087_()) continue;
            if (world.m_46801_(pos)) {
                state = (BlockState)state.m_61124_((Property)VibrionGel.WATERLOGGED, (Comparable)Boolean.valueOf(true));
            }
            world.m_7731_(pos, state, 3);
        }
    }
}

