/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.worldgen.feature.decorator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.farkas.wildaside.block.ModBlocks;
import net.farkas.wildaside.block.custom.FallenHickoryLeavesBlock;
import net.farkas.wildaside.util.HickoryColour;
import net.farkas.wildaside.worldgen.feature.decorator.ModTreeDecorators;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class FallenLeavesDecorator
extends TreeDecorator {
    private final float chance;
    private final HickoryColour colour;
    public static final Codec<FallenLeavesDecorator> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.FLOAT.fieldOf("chance").forGetter(d -> Float.valueOf(d.chance)), (App)Codec.STRING.xmap(HickoryColour::valueOf, Enum::name).fieldOf("colour").forGetter(d -> d.colour)).apply((Applicative)inst, FallenLeavesDecorator::new));

    public FallenLeavesDecorator(float chance, HickoryColour colour) {
        this.chance = chance;
        this.colour = colour;
    }

    protected TreeDecoratorType<?> m_6663_() {
        return (TreeDecoratorType)ModTreeDecorators.FALLEN_LEAVES.get();
    }

    public void m_214187_(TreeDecorator.Context pContext) {
        RandomSource random = pContext.m_226067_();
        ObjectArrayList logs = pContext.m_226068_();
        BlockPos anyLog = (BlockPos)logs.get(0);
        int cx = anyLog.m_123341_();
        int cz = anyLog.m_123343_();
        LevelSimulatedReader reader = pContext.m_226058_();
        int radius = 6;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                if (!(random.m_188501_() < this.chance)) continue;
                int x = cx + dx;
                int z = cz + dz;
                int startY = logs.stream().mapToInt(Vec3i::m_123342_).min().orElse(0) + 5;
                int groundY = -100;
                for (int y = startY; y >= -64; --y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (!reader.m_7433_(pos, bs -> bs.m_204336_(BlockTags.f_144274_))) continue;
                    if (!reader.m_7433_(pos.m_7494_(), bs -> !bs.m_280296_())) break;
                    groundY = y;
                    break;
                }
                if (groundY <= -64) continue;
                BlockPos target = new BlockPos(x, groundY + 1, z);
                int count = 1 + random.m_188503_(3);
                HickoryColour colour = this.colour;
                Direction face = Direction.Plane.HORIZONTAL.m_235690_(random);
                BlockState leafSt = (BlockState)((BlockState)((BlockState)((Block)ModBlocks.FALLEN_HICKORY_LEAVES.get()).m_49966_().m_61124_((Property)FallenHickoryLeavesBlock.COUNT, (Comparable)Integer.valueOf(count))).m_61124_(FallenHickoryLeavesBlock.COLOUR, (Comparable)((Object)colour))).m_61124_((Property)FallenHickoryLeavesBlock.FACING, (Comparable)face);
                pContext.m_226061_(target, leafSt);
            }
        }
    }
}

