/*
 * Decompiled with CFR 0.152.
 */
package com.yamkai.ophanim.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yamkai.ophanim.client.model.Modelseraphim;
import com.yamkai.ophanim.client.model.animations.seraphimAnimation;
import com.yamkai.ophanim.entity.SeraphimEntity;
import com.yamkai.ophanim.procedures.SeraphimReturnEffectCooldownProcedure;
import com.yamkai.ophanim.procedures.SeraphimReturnEffectStartProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class SeraphimRenderer
extends MobRenderer<SeraphimEntity, LivingEntityRenderState, Modelseraphim> {
    private SeraphimEntity entity = null;

    public SeraphimRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelseraphim.LAYER_LOCATION)), 0.24f);
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, Modelseraphim>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"ophanim:textures/entities/texture.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.eyes((ResourceLocation)this.LAYER_TEXTURE));
                ((Modelseraphim)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, Modelseraphim>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"ophanim:textures/entities/red_eye_glow.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = SeraphimRenderer.this.entity.level();
                double x = SeraphimRenderer.this.entity.getX();
                double y = SeraphimRenderer.this.entity.getY();
                double z = SeraphimRenderer.this.entity.getZ();
                if (SeraphimReturnEffectStartProcedure.execute((Entity)SeraphimRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.eyes((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelseraphim)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
                }
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, Modelseraphim>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"ophanim:textures/entities/seraph_cooldown.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = SeraphimRenderer.this.entity.level();
                double x = SeraphimRenderer.this.entity.getX();
                double y = SeraphimRenderer.this.entity.getY();
                double z = SeraphimRenderer.this.entity.getZ();
                if (SeraphimReturnEffectCooldownProcedure.execute((Entity)SeraphimRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelseraphim)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
                }
            }
        });
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(SeraphimEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"ophanim:textures/entities/seraphim.png");
    }

    protected void scale(LivingEntityRenderState state, PoseStack poseStack) {
        poseStack.scale(0.24f, 0.24f, 0.24f);
        poseStack.scale(this.entity.getAgeScale(), this.entity.getAgeScale(), this.entity.getAgeScale());
    }

    private static final class AnimatedModel
    extends Modelseraphim {
        private SeraphimEntity entity = null;

        public AnimatedModel(ModelPart root) {
            super(root);
        }

        public void setEntity(SeraphimEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.animate(this.entity.animationState0, seraphimAnimation.idle, state.ageInTicks, 1.0f);
            this.animate(this.entity.animationState1, seraphimAnimation.attack, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }
    }
}

