/*
 * Decompiled with CFR 0.152.
 */
package fuzs.naturalwaters.client;

import fuzs.naturalwaters.NaturalWaters;
import fuzs.naturalwaters.client.biome.ClientBiomeManager;
import fuzs.naturalwaters.client.packs.OpaqueWaterPackResources;
import fuzs.naturalwaters.client.renderer.ModBiomeColors;
import fuzs.naturalwaters.config.ClientConfig;
import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.event.v1.AddResourcePackReloadListenersCallback;
import fuzs.puzzleslib.api.client.event.v1.level.ClientLevelEvents;
import fuzs.puzzleslib.api.client.event.v1.renderer.FogEvents;
import fuzs.puzzleslib.api.core.v1.context.PackRepositorySourcesContext;
import fuzs.puzzleslib.api.event.v1.server.TagsUpdatedCallback;
import fuzs.puzzleslib.api.resources.v1.PackResourcesHelper;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.fog.FogData;
import net.minecraft.client.renderer.fog.environment.FogEnvironment;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.FogType;
import org.jetbrains.annotations.Nullable;

public class NaturalWatersClient
implements ClientModConstructor {
    public void onConstructMod() {
        NaturalWatersClient.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        AddResourcePackReloadListenersCallback.EVENT.register(ClientBiomeManager::onAddResourcePackReloadListeners);
        TagsUpdatedCallback.EVENT.register(ClientBiomeManager::onTagsUpdated);
        ClientLevelEvents.LOAD.register(ModBiomeColors::onLevelLoad);
        FogEvents.SETUP.register(NaturalWatersClient::onSetupFog);
    }

    private static void onSetupFog(Camera camera, float partialTick, @Nullable FogEnvironment fogEnvironment, FogType fogType, FogData fogData) {
        LocalPlayer localPlayer;
        Holder holder;
        Optional<Float> optional;
        Entity entity;
        if (!((ClientConfig)NaturalWaters.CONFIG.get(ClientConfig.class)).waterFogDistance) {
            return;
        }
        if (fogType == FogType.WATER && (entity = camera.getEntity()) instanceof LocalPlayer && (optional = ClientBiomeManager.getBiomeClientInfo((Holder<Biome>)(holder = (localPlayer = (LocalPlayer)entity).level().getBiome(localPlayer.blockPosition()))).waterFogDistance()).isPresent()) {
            GameRenderer gameRenderer = Minecraft.getInstance().gameRenderer;
            fogData.skyEnd = fogData.cloudEnd = (fogData.environmentalEnd = Math.min(96.0f * Math.max(0.25f, localPlayer.getWaterVision()) * optional.get().floatValue(), gameRenderer.getRenderDistance()));
        }
    }

    public void onAddResourcePackFinders(PackRepositorySourcesContext context) {
        context.registerRepositorySource(PackResourcesHelper.buildClientPack((ResourceLocation)NaturalWaters.id("opaque_water"), OpaqueWaterPackResources::new, (boolean)true));
    }
}

