/*
 * Decompiled with CFR 0.152.
 */
package fuzs.naturalwaters.client.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ARGB;
import net.minecraft.util.ExtraCodecs;

public record BiomeClientInfo(Optional<Integer> waterSurfaceColor, Optional<Integer> waterFogColor, Optional<Float> waterFogDistance, Optional<Float> waterSurfaceTransparency) {
    public static final Codec<Integer> COLOR_CODEC = Codec.withAlternative((Codec)TextColor.CODEC.xmap(TextColor::getValue, TextColor::fromRgb), (Codec)ExtraCodecs.RGB_COLOR_CODEC);
    public static final Codec<BiomeClientInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)COLOR_CODEC.optionalFieldOf("water_surface_color").forGetter(BiomeClientInfo::waterSurfaceColor), (App)COLOR_CODEC.optionalFieldOf("water_fog_color").forGetter(BiomeClientInfo::waterFogColor), (App)ExtraCodecs.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("water_fog_distance").forGetter(BiomeClientInfo::waterFogDistance), (App)ExtraCodecs.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("water_surface_transparency").forGetter(BiomeClientInfo::waterSurfaceTransparency)).apply((Applicative)instance, BiomeClientInfo::new));
    public static final StreamCodec<ByteBuf, BiomeClientInfo> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT.apply(ByteBufCodecs::optional), BiomeClientInfo::waterSurfaceColor, (StreamCodec)ByteBufCodecs.INT.apply(ByteBufCodecs::optional), BiomeClientInfo::waterFogColor, (StreamCodec)ByteBufCodecs.FLOAT.apply(ByteBufCodecs::optional), BiomeClientInfo::waterFogDistance, (StreamCodec)ByteBufCodecs.FLOAT.apply(ByteBufCodecs::optional), BiomeClientInfo::waterSurfaceTransparency, BiomeClientInfo::new);

    public BiomeClientInfo(int waterSurfaceColor, int waterFogColor) {
        this(waterSurfaceColor, waterFogColor, 1.0f);
    }

    public BiomeClientInfo(int waterSurfaceColor, int waterFogColor, float waterFogDistance) {
        this(waterSurfaceColor, waterFogColor, waterFogDistance, 0.75f);
    }

    public BiomeClientInfo(int waterSurfaceColor, int waterFogColor, float waterFogDistance, float waterSurfaceTransparency) {
        this(Optional.of(waterSurfaceColor), Optional.of(waterFogColor), Optional.of(Float.valueOf(waterFogDistance)), Optional.of(Float.valueOf(waterSurfaceTransparency)));
    }

    public Optional<Integer> getWaterFogColor() {
        return this.waterFogColor.or(this::waterSurfaceColor);
    }

    public int getWaterSurfaceTransparency() {
        return ARGB.as8BitChannel((float)this.waterSurfaceTransparency.orElse(Float.valueOf(0.75f)).floatValue());
    }
}

