/*
 * Decompiled with CFR 0.152.
 */
package fuzs.naturalwaters.client.biome;

import com.google.common.collect.ImmutableMap;
import fuzs.naturalwaters.client.biome.BiomeClientInfo;
import fuzs.naturalwaters.client.biome.BuiltInBiomeClientInfos;
import fuzs.naturalwaters.init.ConventionalBiomeTags;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;

public final class ModBiomeClientInfos {
    static final Map<Predicate<Holder<Biome>>, BiomeClientInfo> DYNAMIC_BIOME_CLIENT_INFOS;

    private ModBiomeClientInfos() {
    }

    @SafeVarargs
    static void register(ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo> builder, BiomeClientInfo biomeClientInfo, TagKey<Biome> primaryTagKey, TagKey<Biome> ... secondaryTagKeys) {
        builder.put(holder -> {
            if (holder.is(primaryTagKey)) {
                if (secondaryTagKeys.length != 0) {
                    for (TagKey tagKey : secondaryTagKeys) {
                        if (!holder.is(tagKey)) continue;
                        return true;
                    }
                    return false;
                }
                return true;
            }
            return false;
        }, (Object)biomeClientInfo);
    }

    public static Optional<BiomeClientInfo> pick(Holder<Biome> holder) {
        for (Map.Entry<Predicate<Holder<Biome>>, BiomeClientInfo> entry : DYNAMIC_BIOME_CLIENT_INFOS.entrySet()) {
            if (!entry.getKey().test(holder)) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.HELL, ConventionalBiomeTags.IS_NETHER, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.THE_END, ConventionalBiomeTags.IS_END, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.EXTREME_HILLS, ConventionalBiomeTags.IS_MOUNTAIN, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.EXTREME_HILLS_MUTATED, ConventionalBiomeTags.IS_MOUNTAIN_PEAK, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.EXTREME_HILLS_EDGE, ConventionalBiomeTags.IS_MOUNTAIN_SLOPE, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.ICE_PLAINS, ConventionalBiomeTags.IS_PLAINS, ConventionalBiomeTags.IS_COLD, ConventionalBiomeTags.IS_ICY, ConventionalBiomeTags.IS_SNOWY);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.ICE_PLAINS, ConventionalBiomeTags.IS_SNOWY_PLAINS, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.PLAINS, ConventionalBiomeTags.IS_PLAINS, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.FOREST_HILLS, ConventionalBiomeTags.IS_FOREST, ConventionalBiomeTags.IS_HILL);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.FLOWER_FOREST, ConventionalBiomeTags.IS_FLOWER_FOREST, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.FOREST, ConventionalBiomeTags.IS_FOREST, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.BIRCH_FOREST_HILLS, ConventionalBiomeTags.IS_BIRCH_FOREST, ConventionalBiomeTags.IS_HILL);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.BIRCH_FOREST, ConventionalBiomeTags.IS_BIRCH_FOREST, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.ROOFED_FOREST, ConventionalBiomeTags.IS_DARK_FOREST, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.COLD_TAIGA, ConventionalBiomeTags.IS_TAIGA, ConventionalBiomeTags.IS_COLD, ConventionalBiomeTags.IS_ICY, ConventionalBiomeTags.IS_SNOWY);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.MEGA_TAIGA, ConventionalBiomeTags.IS_TAIGA, ConventionalBiomeTags.IS_OLD_GROWTH);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.TAIGA_HILLS, ConventionalBiomeTags.IS_TAIGA, ConventionalBiomeTags.IS_HILL);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.TAIGA, ConventionalBiomeTags.IS_TAIGA, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.JUNGLE_HILLS, ConventionalBiomeTags.IS_JUNGLE, ConventionalBiomeTags.IS_HILL);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.JUNGLE, ConventionalBiomeTags.IS_JUNGLE, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.SAVANNA_PLATEAU, ConventionalBiomeTags.IS_SAVANNA, ConventionalBiomeTags.IS_PLATEAU);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.SAVANNA_PLATEAU, ConventionalBiomeTags.IS_SAVANNA, ConventionalBiomeTags.IS_HILL);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.SAVANNA, ConventionalBiomeTags.IS_SAVANNA, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.SWAMPLAND_MUTATED, ConventionalBiomeTags.IS_SWAMP, ConventionalBiomeTags.IS_HILL);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.SWAMPLAND, ConventionalBiomeTags.IS_SWAMP, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.DESERT_HILLS, ConventionalBiomeTags.IS_DESERT, ConventionalBiomeTags.IS_HILL);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.DESERT, ConventionalBiomeTags.IS_DESERT, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.MESA_PLATEAU, ConventionalBiomeTags.IS_BADLANDS, ConventionalBiomeTags.IS_PLATEAU);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.MESA_PLATEAU, ConventionalBiomeTags.IS_BADLANDS, ConventionalBiomeTags.IS_HILL);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.MESA, ConventionalBiomeTags.IS_BADLANDS, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.COLD_BEACH, ConventionalBiomeTags.IS_BEACH, ConventionalBiomeTags.IS_COLD, ConventionalBiomeTags.IS_ICY, ConventionalBiomeTags.IS_SNOWY);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.BEACH, ConventionalBiomeTags.IS_BEACH, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.STONE_BEACH, ConventionalBiomeTags.IS_STONY_SHORES, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.MUSHROOM_ISLAND, ConventionalBiomeTags.IS_MUSHROOM, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.FROZEN_RIVER, ConventionalBiomeTags.IS_RIVER, ConventionalBiomeTags.IS_COLD, ConventionalBiomeTags.IS_ICY, ConventionalBiomeTags.IS_SNOWY);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.RIVER, ConventionalBiomeTags.IS_RIVER, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.FROZEN_OCEAN, ConventionalBiomeTags.IS_SHALLOW_OCEAN, ConventionalBiomeTags.IS_AQUATIC_ICY, ConventionalBiomeTags.IS_ICY, ConventionalBiomeTags.IS_SNOWY);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.COLD_OCEAN, ConventionalBiomeTags.IS_SHALLOW_OCEAN, ConventionalBiomeTags.IS_COLD);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.OCEAN, ConventionalBiomeTags.IS_SHALLOW_OCEAN, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.DEEP_FROZEN_OCEAN, ConventionalBiomeTags.IS_DEEP_OCEAN, ConventionalBiomeTags.IS_AQUATIC_ICY, ConventionalBiomeTags.IS_ICY, ConventionalBiomeTags.IS_SNOWY);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.DEEP_COLD_OCEAN, ConventionalBiomeTags.IS_DEEP_OCEAN, ConventionalBiomeTags.IS_COLD);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.DEEP_OCEAN, ConventionalBiomeTags.IS_DEEP_OCEAN, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.FROZEN_OCEAN, ConventionalBiomeTags.IS_OCEAN, ConventionalBiomeTags.IS_AQUATIC_ICY, ConventionalBiomeTags.IS_ICY, ConventionalBiomeTags.IS_SNOWY);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.COLD_OCEAN, ConventionalBiomeTags.IS_OCEAN, ConventionalBiomeTags.IS_COLD);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.OCEAN, ConventionalBiomeTags.IS_OCEAN, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.DEFAULT, ConventionalBiomeTags.IS_UNDERGROUND, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.DEFAULT, ConventionalBiomeTags.IS_CAVE, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.JUNGLE, ConventionalBiomeTags.IS_LUSH, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.MUSHROOM_ISLAND, ConventionalBiomeTags.IS_MAGICAL, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.PALE_GARDEN, ConventionalBiomeTags.IS_SPOOKY, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.FLOWER_FOREST, ConventionalBiomeTags.IS_FLORAL, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.DESERT, ConventionalBiomeTags.IS_SANDY, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.DESERT, ConventionalBiomeTags.IS_HOT, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.FOREST, ConventionalBiomeTags.IS_TEMPERATE, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.TAIGA, ConventionalBiomeTags.IS_COLD, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.SWAMPLAND, ConventionalBiomeTags.IS_WET, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.DESERT, ConventionalBiomeTags.IS_DRY, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.ICE_PLAINS, ConventionalBiomeTags.IS_SNOWY, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.ICE_PLAINS_SPIKES, ConventionalBiomeTags.IS_ICY, new TagKey[0]);
        ModBiomeClientInfos.register((ImmutableMap.Builder<Predicate<Holder<Biome>>, BiomeClientInfo>)builder, BuiltInBiomeClientInfos.OCEAN, ConventionalBiomeTags.IS_AQUATIC, new TagKey[0]);
        DYNAMIC_BIOME_CLIENT_INFOS = builder.build();
    }
}

