/*
 * Decompiled with CFR 0.152.
 */
package fuzs.naturalwaters.client.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.class_5251;
import net.minecraft.class_5699;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9848;

public record BiomeClientInfo(Optional<Integer> waterSurfaceColor, Optional<Integer> waterFogColor, Optional<Float> waterFogDistance, Optional<Float> waterSurfaceTransparency) {
    public static final Codec<Integer> COLOR_CODEC = Codec.withAlternative((Codec)class_5251.field_39242.xmap(class_5251::method_27716, class_5251::method_27717), (Codec)class_5699.field_54067);
    public static final Codec<BiomeClientInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)COLOR_CODEC.optionalFieldOf("water_surface_color").forGetter(BiomeClientInfo::waterSurfaceColor), (App)COLOR_CODEC.optionalFieldOf("water_fog_color").forGetter(BiomeClientInfo::waterFogColor), (App)class_5699.method_65311((float)0.0f, (float)1.0f).optionalFieldOf("water_fog_distance").forGetter(BiomeClientInfo::waterFogDistance), (App)class_5699.method_65311((float)0.0f, (float)1.0f).optionalFieldOf("water_surface_transparency").forGetter(BiomeClientInfo::waterSurfaceTransparency)).apply((Applicative)instance, BiomeClientInfo::new));
    public static final class_9139<ByteBuf, BiomeClientInfo> STREAM_CODEC = class_9139.method_56905((class_9139)class_9135.field_49675.method_56433(class_9135::method_56382), BiomeClientInfo::waterSurfaceColor, (class_9139)class_9135.field_49675.method_56433(class_9135::method_56382), BiomeClientInfo::waterFogColor, (class_9139)class_9135.field_48552.method_56433(class_9135::method_56382), BiomeClientInfo::waterFogDistance, (class_9139)class_9135.field_48552.method_56433(class_9135::method_56382), BiomeClientInfo::waterSurfaceTransparency, BiomeClientInfo::new);

    public BiomeClientInfo(int waterSurfaceColor, int waterFogColor) {
        this(waterSurfaceColor, waterFogColor, 1.0f);
    }

    public BiomeClientInfo(int waterSurfaceColor, int waterFogColor, float waterFogDistance) {
        this(waterSurfaceColor, waterFogColor, waterFogDistance, 0.75f);
    }

    public BiomeClientInfo(int waterSurfaceColor, int waterFogColor, float waterFogDistance, float waterSurfaceTransparency) {
        this(Optional.of(waterSurfaceColor), Optional.of(waterFogColor), Optional.of(Float.valueOf(waterFogDistance)), Optional.of(Float.valueOf(waterSurfaceTransparency)));
    }

    public Optional<Integer> getWaterFogColor() {
        return this.waterFogColor.or(this::waterSurfaceColor);
    }

    public int getWaterSurfaceTransparency() {
        return class_9848.method_61326((float)this.waterSurfaceTransparency.orElse(Float.valueOf(0.75f)).floatValue());
    }
}

