/*
 * Decompiled with CFR 0.152.
 */
package fuzs.naturalwaters.client.biome;

import com.google.common.collect.ImmutableMap;
import fuzs.naturalwaters.NaturalWaters;
import fuzs.naturalwaters.client.biome.BiomeClientInfo;
import fuzs.naturalwaters.client.biome.ModBiomeClientInfos;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5321;
import net.minecraft.class_634;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7654;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public final class ClientBiomeManager
extends class_4309<BiomeClientInfo> {
    public static final String ASSET_DIRECTORY = "naturalwaters/biomes";
    private static final class_7654 ASSET_LISTER = class_7654.method_45114((String)"naturalwaters/biomes");
    static final BiomeClientInfo BUILT_IN_FALLBACK = new BiomeClientInfo(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    @Nullable
    private static ClientBiomeManager instance;
    private Map<class_5321<class_1959>, BiomeClientInfo> biomeClientInfos = Map.of();
    private Map<class_5321<class_1959>, BiomeClientInfo> resolvedBiomeClientInfos = Map.of();

    public ClientBiomeManager() {
        super(BiomeClientInfo.CODEC, ASSET_LISTER);
    }

    protected void apply(Map<class_2960, BiomeClientInfo> map, class_3300 resourceManager, class_3695 profiler) {
        this.resolvedBiomeClientInfos = map.entrySet().stream().collect(Collectors.toUnmodifiableMap(entry -> class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)((class_2960)entry.getKey())), Map.Entry::getValue));
        this.biomeClientInfos = this.resolvedBiomeClientInfos;
        class_634 clientPacketListener = class_310.method_1551().method_1562();
        if (clientPacketListener != null) {
            this.resolvedBiomeClientInfos = ClientBiomeManager.fillMissingBiomeClientInfos((class_7225.class_7226<class_1959>)clientPacketListener.method_29091().method_30530(class_7924.field_41236), new IdentityHashMap<class_5321<class_1959>, BiomeClientInfo>(this.biomeClientInfos));
        }
    }

    public static BiomeClientInfo getBiomeClientInfo(class_1959 biome) {
        class_634 clientPacketListener = class_310.method_1551().method_1562();
        if (clientPacketListener != null) {
            return clientPacketListener.method_29091().method_46759(class_7924.field_41236).flatMap(registry -> registry.method_29113((Object)biome)).map(ClientBiomeManager::getBiomeClientInfo).orElse(BUILT_IN_FALLBACK);
        }
        return BUILT_IN_FALLBACK;
    }

    public static BiomeClientInfo getBiomeClientInfo(class_6880<class_1959> holder) {
        return holder.method_40230().map(ClientBiomeManager::getBiomeClientInfo).orElse(BUILT_IN_FALLBACK);
    }

    public static BiomeClientInfo getBiomeClientInfo(class_5321<class_1959> resourceKey) {
        ClientBiomeManager clientBiomeManager = instance;
        if (clientBiomeManager != null) {
            return clientBiomeManager.resolvedBiomeClientInfos.getOrDefault(resourceKey, BUILT_IN_FALLBACK);
        }
        return BUILT_IN_FALLBACK;
    }

    public static void onAddResourcePackReloadListeners(BiConsumer<class_2960, class_3302> consumer) {
        instance = new ClientBiomeManager();
        consumer.accept(NaturalWaters.id("client_biome_manager"), (class_3302)instance);
    }

    public static void onTagsUpdated(class_7225.class_7874 registries, boolean client) {
        ClientBiomeManager clientBiomeManager;
        if (client && (clientBiomeManager = instance) != null) {
            clientBiomeManager.resolvedBiomeClientInfos = ClientBiomeManager.fillMissingBiomeClientInfos((class_7225.class_7226<class_1959>)registries.method_46762(class_7924.field_41236), new IdentityHashMap<class_5321<class_1959>, BiomeClientInfo>(clientBiomeManager.biomeClientInfos));
        }
    }

    static Map<class_5321<class_1959>, BiomeClientInfo> fillMissingBiomeClientInfos(class_7225.class_7226<class_1959> biomeLookup, Map<class_5321<class_1959>, BiomeClientInfo> biomeClientInfos) {
        biomeLookup.method_42017().forEach(holder -> {
            if (!biomeClientInfos.containsKey(holder.method_40237())) {
                ModBiomeClientInfos.pick((class_6880<class_1959>)holder).ifPresent(biomeClientInfo -> biomeClientInfos.put((class_5321<class_1959>)holder.method_40237(), (BiomeClientInfo)biomeClientInfo));
            }
        });
        return ImmutableMap.copyOf(biomeClientInfos);
    }
}

