/*
 * Decompiled with CFR 0.152.
 */
package fuzs.naturalwaters.client;

import com.mojang.blaze3d.shaders.FogShape;
import fuzs.naturalwaters.NaturalWaters;
import fuzs.naturalwaters.client.biome.ClientBiomeManager;
import fuzs.naturalwaters.client.packs.OpaqueWaterPackResources;
import fuzs.naturalwaters.client.renderer.ModBiomeColors;
import fuzs.naturalwaters.config.ClientConfig;
import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.event.v1.AddResourcePackReloadListenersCallback;
import fuzs.puzzleslib.api.client.event.v1.level.ClientLevelEvents;
import fuzs.puzzleslib.api.client.event.v1.renderer.FogEvents;
import fuzs.puzzleslib.api.core.v1.context.PackRepositorySourcesContext;
import fuzs.puzzleslib.api.event.v1.server.TagsUpdatedCallback;
import fuzs.puzzleslib.api.resources.v1.PackResourcesHelper;
import java.util.Optional;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.FogType;

public class NaturalWatersClient
implements ClientModConstructor {
    public void onConstructMod() {
        NaturalWatersClient.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        AddResourcePackReloadListenersCallback.EVENT.register(ClientBiomeManager::onAddResourcePackReloadListeners);
        TagsUpdatedCallback.EVENT.register(ClientBiomeManager::onTagsUpdated);
        ClientLevelEvents.LOAD.register(ModBiomeColors::onLevelLoad);
        FogEvents.RENDER.register((gameRenderer, camera, partialTick, fogMode, fogType, fogStart, fogEnd, fogShape) -> {
            LocalPlayer localPlayer;
            Holder holder;
            Optional<Float> optional;
            Entity patt0$temp;
            if (!((ClientConfig)NaturalWaters.CONFIG.get(ClientConfig.class)).waterFogDistance) {
                return;
            }
            if (fogType == FogType.WATER && (patt0$temp = camera.getEntity()) instanceof LocalPlayer && (optional = ClientBiomeManager.getBiomeClientInfo((Holder<Biome>)(holder = (localPlayer = (LocalPlayer)patt0$temp).level().getBiome(localPlayer.blockPosition()))).waterFogDistance()).isPresent()) {
                fogEnd.accept(96.0f * Math.max(0.25f, localPlayer.getWaterVision()) * optional.get().floatValue());
                if (fogEnd.getAsFloat() > gameRenderer.getRenderDistance()) {
                    fogEnd.accept(gameRenderer.getRenderDistance());
                } else {
                    fogShape.accept((Object)FogShape.SPHERE);
                }
            }
        });
    }

    public void onAddResourcePackFinders(PackRepositorySourcesContext context) {
        context.addRepositorySource(PackResourcesHelper.buildClientPack((ResourceLocation)NaturalWaters.id("opaque_water"), OpaqueWaterPackResources::new, (boolean)true));
    }
}

