/*
 * Decompiled with CFR 0.152.
 */
package fuzs.naturalwaters.client.biome;

import com.google.common.collect.ImmutableMap;
import fuzs.naturalwaters.NaturalWaters;
import fuzs.naturalwaters.client.biome.BiomeClientInfo;
import fuzs.naturalwaters.client.biome.ModBiomeClientInfos;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.Nullable;

public final class ClientBiomeManager
extends SimpleJsonResourceReloadListener<BiomeClientInfo> {
    public static final String ASSET_DIRECTORY = "naturalwaters/biomes";
    private static final FileToIdConverter ASSET_LISTER = FileToIdConverter.json((String)"naturalwaters/biomes");
    static final BiomeClientInfo BUILT_IN_FALLBACK = new BiomeClientInfo(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    @Nullable
    private static ClientBiomeManager instance;
    private Map<ResourceKey<Biome>, BiomeClientInfo> biomeClientInfos = Map.of();
    private Map<ResourceKey<Biome>, BiomeClientInfo> resolvedBiomeClientInfos = Map.of();

    public ClientBiomeManager() {
        super(BiomeClientInfo.CODEC, ASSET_LISTER);
    }

    protected void apply(Map<ResourceLocation, BiomeClientInfo> map, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.resolvedBiomeClientInfos = map.entrySet().stream().collect(Collectors.toUnmodifiableMap(entry -> ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)((ResourceLocation)entry.getKey())), Map.Entry::getValue));
        this.biomeClientInfos = this.resolvedBiomeClientInfos;
        ClientPacketListener clientPacketListener = Minecraft.getInstance().getConnection();
        if (clientPacketListener != null) {
            this.resolvedBiomeClientInfos = ClientBiomeManager.fillMissingBiomeClientInfos((HolderLookup.RegistryLookup<Biome>)clientPacketListener.registryAccess().lookupOrThrow(Registries.BIOME), new IdentityHashMap<ResourceKey<Biome>, BiomeClientInfo>(this.biomeClientInfos));
        }
    }

    public static BiomeClientInfo getBiomeClientInfo(Biome biome) {
        ClientPacketListener clientPacketListener = Minecraft.getInstance().getConnection();
        if (clientPacketListener != null) {
            return clientPacketListener.registryAccess().lookup(Registries.BIOME).flatMap(registry -> registry.getResourceKey((Object)biome)).map(ClientBiomeManager::getBiomeClientInfo).orElse(BUILT_IN_FALLBACK);
        }
        return BUILT_IN_FALLBACK;
    }

    public static BiomeClientInfo getBiomeClientInfo(Holder<Biome> holder) {
        return holder.unwrapKey().map(ClientBiomeManager::getBiomeClientInfo).orElse(BUILT_IN_FALLBACK);
    }

    public static BiomeClientInfo getBiomeClientInfo(ResourceKey<Biome> resourceKey) {
        ClientBiomeManager clientBiomeManager = instance;
        if (clientBiomeManager != null) {
            return clientBiomeManager.resolvedBiomeClientInfos.getOrDefault(resourceKey, BUILT_IN_FALLBACK);
        }
        return BUILT_IN_FALLBACK;
    }

    public static void onAddResourcePackReloadListeners(BiConsumer<ResourceLocation, PreparableReloadListener> consumer) {
        instance = new ClientBiomeManager();
        consumer.accept(NaturalWaters.id("client_biome_manager"), (PreparableReloadListener)instance);
    }

    public static void onTagsUpdated(HolderLookup.Provider registries, boolean client) {
        ClientBiomeManager clientBiomeManager;
        if (client && (clientBiomeManager = instance) != null) {
            clientBiomeManager.resolvedBiomeClientInfos = ClientBiomeManager.fillMissingBiomeClientInfos((HolderLookup.RegistryLookup<Biome>)registries.lookupOrThrow(Registries.BIOME), new IdentityHashMap<ResourceKey<Biome>, BiomeClientInfo>(clientBiomeManager.biomeClientInfos));
        }
    }

    static Map<ResourceKey<Biome>, BiomeClientInfo> fillMissingBiomeClientInfos(HolderLookup.RegistryLookup<Biome> biomeLookup, Map<ResourceKey<Biome>, BiomeClientInfo> biomeClientInfos) {
        biomeLookup.listElements().forEach(holder -> {
            if (!biomeClientInfos.containsKey(holder.key())) {
                ModBiomeClientInfos.pick((Holder<Biome>)holder).ifPresent(biomeClientInfo -> biomeClientInfos.put((ResourceKey<Biome>)holder.key(), (BiomeClientInfo)biomeClientInfo));
            }
        });
        return ImmutableMap.copyOf(biomeClientInfos);
    }
}

