/*
 * Decompiled with CFR 0.152.
 */
package fuzs.naturalwaters.neoforge.client.renderer.block;

import fuzs.naturalwaters.client.packs.OpaqueWaterPackResources;
import fuzs.naturalwaters.client.renderer.ModBiomeColors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;

public final class NeoForgeWaterBlockRenderer
implements IClientFluidTypeExtensions {
    private static final int NORMAL_WATER_COLOR = 4159204;
    private static final ResourceLocation UNDERWATER_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/misc/underwater.png");

    public ResourceLocation getStillTexture() {
        return OpaqueWaterPackResources.getWaterStillMaterial().texture();
    }

    public ResourceLocation getFlowingTexture() {
        return OpaqueWaterPackResources.getWaterFlowMaterial().texture();
    }

    public ResourceLocation getOverlayTexture() {
        return ModelBakery.WATER_OVERLAY.texture();
    }

    public ResourceLocation getRenderOverlayTexture(Minecraft minecraft) {
        return UNDERWATER_LOCATION;
    }

    public int getTintColor() {
        return 4159204;
    }

    public int getTintColor(FluidState fluidState, BlockAndTintGetter level, BlockPos blockPos) {
        return ARGB.opaque((int)ModBiomeColors.getAverageWaterColor(level, blockPos));
    }
}

