/*
 * Decompiled with CFR 0.152.
 */
package fuzs.naturalwaters.client.packs;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.NativeImage;
import fuzs.naturalwaters.NaturalWaters;
import fuzs.naturalwaters.config.ClientConfig;
import fuzs.puzzleslib.api.client.packs.v1.NativeImageHelper;
import fuzs.puzzleslib.api.resources.v1.AbstractModPackResources;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.ARGB;
import org.jetbrains.annotations.Nullable;

public class OpaqueWaterPackResources
extends AbstractModPackResources {
    public static final Material WATER_STILL_MATERIAL = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace((String)"block/water_still"));
    public static final Material WATER_FLOW_MATERIAL = ModelBakery.WATER_FLOW;
    public static final Material OPAQUE_WATER_STILL_MATERIAL = new Material(TextureAtlas.LOCATION_BLOCKS, NaturalWaters.id(WATER_STILL_MATERIAL.texture().getPath()));
    public static final Material OPAQUE_WATER_FLOW_MATERIAL = new Material(TextureAtlas.LOCATION_BLOCKS, NaturalWaters.id(WATER_FLOW_MATERIAL.texture().getPath()));
    private static final Map<ResourceLocation, ResourceLocation> RESOURCE_LOCATIONS;
    private final ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();

    static void registerTextureMapping(BiConsumer<ResourceLocation, ResourceLocation> consumer, ResourceLocation providedResourceLocation, ResourceLocation originalResourceLocation) {
        consumer.accept(OpaqueWaterPackResources.getTextureLocation(providedResourceLocation), OpaqueWaterPackResources.getTextureLocation(originalResourceLocation));
        consumer.accept(OpaqueWaterPackResources.getMetadataLocation(providedResourceLocation), OpaqueWaterPackResources.getMetadataLocation(originalResourceLocation));
    }

    static ResourceLocation getTextureLocation(ResourceLocation resourceLocation) {
        return resourceLocation.withPath(s -> "textures/" + s + ".png");
    }

    static ResourceLocation getMetadataLocation(ResourceLocation resourceLocation) {
        return resourceLocation.withPath(s -> "textures/" + s + ".png.mcmeta");
    }

    public static Material getWaterStillMaterial() {
        if (((ClientConfig)NaturalWaters.CONFIG.get(ClientConfig.class)).waterSurfaceTransparency) {
            return OPAQUE_WATER_STILL_MATERIAL;
        }
        return WATER_STILL_MATERIAL;
    }

    public static Material getWaterFlowMaterial() {
        if (((ClientConfig)NaturalWaters.CONFIG.get(ClientConfig.class)).waterSurfaceTransparency) {
            return OPAQUE_WATER_FLOW_MATERIAL;
        }
        return WATER_FLOW_MATERIAL;
    }

    @Nullable
    public IoSupplier<InputStream> getResource(PackType packType, ResourceLocation resourceLocation) {
        if (RESOURCE_LOCATIONS.containsKey(resourceLocation)) {
            Optional optional = this.resourceManager.getResource(RESOURCE_LOCATIONS.get(resourceLocation));
            if (optional.isPresent()) {
                if (resourceLocation.getPath().endsWith(".png")) {
                    IoSupplier ioSupplier;
                    block13: {
                        NativeImage nativeImage = NativeImage.read((InputStream)((Resource)optional.get()).open());
                        try {
                            for (int x = 0; x < nativeImage.getWidth(); ++x) {
                                for (int y = 0; y < nativeImage.getHeight(); ++y) {
                                    int pixel = nativeImage.getPixel(x, y);
                                    int alpha = ARGB.alpha((int)pixel);
                                    if (alpha == 0) continue;
                                    nativeImage.setPixel(x, y, ARGB.opaque((int)pixel));
                                }
                            }
                            byte[] byteArray = NativeImageHelper.asByteArray((NativeImage)nativeImage);
                            ioSupplier = () -> new ByteArrayInputStream(byteArray);
                            if (nativeImage == null) break block13;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (nativeImage != null) {
                                    try {
                                        nativeImage.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IOException iOException) {
                            }
                        }
                        nativeImage.close();
                    }
                    return ioSupplier;
                }
                return () -> ((Resource)((Resource)optional.get())).open();
            }
            return null;
        }
        return super.getResource(packType, resourceLocation);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        OpaqueWaterPackResources.registerTextureMapping((arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1), OPAQUE_WATER_STILL_MATERIAL.texture(), WATER_STILL_MATERIAL.texture());
        OpaqueWaterPackResources.registerTextureMapping((arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1), OPAQUE_WATER_FLOW_MATERIAL.texture(), WATER_FLOW_MATERIAL.texture());
        RESOURCE_LOCATIONS = builder.build();
    }
}

