/*
 * Decompiled with CFR 0.152.
 */
package fuzs.naturalwaters.client.renderer;

import fuzs.naturalwaters.NaturalWaters;
import fuzs.naturalwaters.client.biome.ClientBiomeManager;
import fuzs.naturalwaters.config.ClientConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockTintCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.biome.Biome;

public class ModBiomeColors {
    public static final ColorResolver WATER_COLOR_RESOLVER = (biome, x, y) -> ClientBiomeManager.getBiomeClientInfo(biome).waterSurfaceColor().orElseGet(() -> ((Biome)biome).getWaterColor());
    public static final ColorResolver WATER_TRANSPARENCY_RESOLVER = (biome, x, z) -> ClientBiomeManager.getBiomeClientInfo(biome).getWaterSurfaceTransparency();

    public static void onLevelLoad(Minecraft minecraft, ClientLevel clientLevel) {
        if (((ClientConfig)NaturalWaters.CONFIG.get(ClientConfig.class)).waterSurfaceColor) {
            clientLevel.tintCaches.put((Object)BiomeColors.WATER_COLOR_RESOLVER, (Object)new BlockTintCache(blockPos -> clientLevel.calculateBlockTint(blockPos, WATER_COLOR_RESOLVER)));
        }
        clientLevel.tintCaches.put((Object)WATER_TRANSPARENCY_RESOLVER, (Object)new BlockTintCache(blockPos -> clientLevel.calculateBlockTint(blockPos, WATER_TRANSPARENCY_RESOLVER)));
    }

    public static float getAverageWaterTransparency(BlockAndTintGetter level, BlockPos blockPos) {
        return (float)level.getBlockTint(blockPos, WATER_TRANSPARENCY_RESOLVER) / 255.0f * 0.95f;
    }
}

